package com.xforceplus.purchaserordersaas.controller;


/**
 * 业务单与发票的关系对象feign客户端
 *
 * @author ultraman
 * @date 2023-09-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.BizOrderInvoiceRelation;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-order-saas")
public interface BizOrderInvoiceRelationFeignApi {

  /**
   * 通过id查询业务单与发票的关系对象
   * @param  id
   * @return R
   */
  @GetMapping("/bizOrderInvoiceRelation/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务单与发票的关系对象
   * @param bizOrderInvoiceRelation 业务单与发票的关系对象
   * @return R
   */
  @PostMapping("/bizOrderInvoiceRelation/add")
  public R save(@RequestBody BizOrderInvoiceRelation bizOrderInvoiceRelation);

  /**
   * 修改业务单与发票的关系对象
   * @param bizOrderInvoiceRelation 业务单与发票的关系对象
   * @return R
   */
  @PostMapping("/bizOrderInvoiceRelation/update")
  public R updateById(@RequestBody BizOrderInvoiceRelation bizOrderInvoiceRelation);

  /**
   * 通过id删除业务单与发票的关系对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/bizOrderInvoiceRelation/del/{id}" )
  public R removeById(@PathVariable Long id);

}