package com.xforceplus.purchaserordersaas.controller;


/**
 * 风险邮包对象feign客户端
 *
 * @author ultraman
 * @date 2023-09-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.ParcelPostException;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-order-saas")
public interface ParcelPostExceptionFeignApi {

  /**
   * 通过id查询风险邮包对象
   * @param  id
   * @return R
   */
  @GetMapping("/parcelPostException/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增风险邮包对象
   * @param parcelPostException 风险邮包对象
   * @return R
   */
  @PostMapping("/parcelPostException/add")
  public R save(@RequestBody ParcelPostException parcelPostException);

  /**
   * 修改风险邮包对象
   * @param parcelPostException 风险邮包对象
   * @return R
   */
  @PostMapping("/parcelPostException/update")
  public R updateById(@RequestBody ParcelPostException parcelPostException);

  /**
   * 通过id删除风险邮包对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/parcelPostException/del/{id}" )
  public R removeById(@PathVariable Long id);

}