package com.xforceplus.purchaserordersaas.controller;


/**
 * 业务单操作履历feign客户端
 *
 * @author ultraman
 * @date 2023-09-25
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.BizOrderOperateLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-order-saas")
public interface BizOrderOperateLogFeignApi {

  /**
   * 通过id查询业务单操作履历
   * @param  id
   * @return R
   */
  @GetMapping("/bizOrderOperateLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务单操作履历
   * @param bizOrderOperateLog 业务单操作履历
   * @return R
   */
  @PostMapping("/bizOrderOperateLog/add")
  public R save(@RequestBody BizOrderOperateLog bizOrderOperateLog);

  /**
   * 修改业务单操作履历
   * @param bizOrderOperateLog 业务单操作履历
   * @return R
   */
  @PostMapping("/bizOrderOperateLog/update")
  public R updateById(@RequestBody BizOrderOperateLog bizOrderOperateLog);

  /**
   * 通过id删除业务单操作履历
   * @param  id
   * @return R
   */
  @DeleteMapping("/bizOrderOperateLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}