package com.xforceplus.purchaserordersaas.controller;


/**
 * 迁移使用feign客户端
 *
 * @author ultraman
 * @date 2024-06-03
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.WkException;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-order-saas")
public interface WkExceptionFeignApi {

  /**
   * 通过id查询迁移使用
   * @param  id
   * @return R
   */
  @GetMapping("/wkException/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增迁移使用
   * @param wkException 迁移使用
   * @return R
   */
  @PostMapping("/wkException/add")
  public R save(@RequestBody WkException wkException);

  /**
   * 修改迁移使用
   * @param wkException 迁移使用
   * @return R
   */
  @PostMapping("/wkException/update")
  public R updateById(@RequestBody WkException wkException);

  /**
   * 通过id删除迁移使用
   * @param  id
   * @return R
   */
  @DeleteMapping("/wkException/del/{id}" )
  public R removeById(@PathVariable Long id);

}