package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 审批状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-12
 */
public enum AuditStatus {

    _1("1", "正常状态"),
    _2("2", "审批中"),
    _3("3", "通过"),
    _4("4", "驳回"),
    _5("5", "取消审批申请");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AuditStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuditStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
