package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * AR/AP类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-12
 */
public enum BusinessBillType {

    AR("AR", "销项单据"),
    AP("AP", "进项单据");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BusinessBillType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessBillType fromCode(String code){
        switch(code) {
            case "AR":
                return AR;
            case "AP":
                return AP;
            default:
                return null;
        }
    }
}
