package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-12
 */
public enum InvoiceType {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    CZ("cz", "纸质发票（普通发票）"),
    SZ("sz", "纸质发票（增值税专用发票）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            case "cz":
                return CZ;
            case "sz":
                return SZ;
            default:
                return null;
        }
    }
}
