package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 分类码
 * </p>
 *
 * @author ultraman
 * @since 2023-07-12
 */
public enum ItemTypeCode {

    _01("01", "成品油"),
    _02("02", "稀土"),
    _03("03", "建筑服务"),
    _04("04", "货物运输服务"),
    _05("05", "不动产销售"),
    _06("06", "不动产经营租赁服务"),
    CPY("CPY", "成品油"),
    JDC("JDC", "机动车"),
    KCP("KCP", "矿产品");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ItemTypeCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ItemTypeCode fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "CPY":
                return CPY;
            case "JDC":
                return JDC;
            case "KCP":
                return KCP;
            default:
                return null;
        }
    }
}
