package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据认证状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-26
 */
public enum BillAuthStatus {

    _2("2", "未勾选"),
    _4("4", "已勾选"),
    _5("5", "勾选异常"),
    _6("6", "抵扣异常"),
    _8("8", "已确认抵扣"),
    _9("9", "部分勾选"),
    _10("10", "部分抵扣");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillAuthStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillAuthStatus fromCode(String code){
        switch(code) {
            case "2":
                return _2;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            default:
                return null;
        }
    }
}
