package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-26
 */
public enum BillInvoiceType {

    S("s", "纸质发票（增值税专用发票）"),
    SE("se", "电子发票（增值税专用发票）"),
    C("c", "纸质发票（增值税普通发票）"),
    CE("ce", "电子发票（增值税普通发票）"),
    JU("ju", "增值税普通发票（卷票）"),
    CT("ct", "通行费增值税电子普通发票"),
    V("v", "机动车统一销售发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillInvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillInvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "se":
                return SE;
            case "c":
                return C;
            case "ce":
                return CE;
            case "ju":
                return JU;
            case "ct":
                return CT;
            case "v":
                return V;
            default:
                return null;
        }
    }
}
