package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 明细来源
 * </p>
 *
 * @author ultraman
 * @since 2023-07-26
 */
public enum ItemOrigin {

    _0("0", "原始业务单"),
    _1("1", "手动拆分业务单"),
    _2("2", "手动合并业务单"),
    _3("3", "自动合并业务单"),
    _4("4", "平台手动组合"),
    _5("5", "接口API组合"),
    _6("6", "自动拆分部分开票状态明细"),
    _7("7", "虚拟明细");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ItemOrigin(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ItemOrigin fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
