package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 上传方确认标识
 * </p>
 *
 * @author ultraman
 * @since 2023-07-26
 */
public enum UploadConfirmFlag {

    _4("4", "开票待提交"),
    _5("5", "已开票"),
    _3("3", "对方确认中"),
    _1("1", "待确认"),
    _2("2", "有变更"),
    _7("7", "开票已提交"),
    _8("8", "已寄送"),
    __1("-1", "无效状态"),
    _0("0", "已作废");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    UploadConfirmFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static UploadConfirmFlag fromCode(String code){
        switch(code) {
            case "4":
                return _4;
            case "5":
                return _5;
            case "3":
                return _3;
            case "1":
                return _1;
            case "2":
                return _2;
            case "7":
                return _7;
            case "8":
                return _8;
            case "-1":
                return __1;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
