package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 上传方确认标识
 * </p>
 *
 * @author ultraman
 * @since 2023-07-13
 */
public enum UploadConfirmFlag {

    _4("4", "开票待提交"),
    _5("5", "已开票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    UploadConfirmFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static UploadConfirmFlag fromCode(String code){
        switch(code) {
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
