package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ant_status
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
public enum AntStatus {

    _0("0", "待确认"),
    _1("1", "待开票"),
    _2("2", "已开票"),
    _3("3", "已作废"),
    _5("5", "待购方审核"),
    _6("6", "无需开票"),
    _8("8", "已拒绝"),
    _9("9", "异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AntStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AntStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "5":
                return _5;
            case "6":
                return _6;
            case "8":
                return _8;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
