package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_order_type
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
public enum BizOrderType {

    采购订单("采购订单", "采购订单"),
    简易合同("简易合同", "简易合同"),
    非现金支付("非现金支付", "非现金支付"),
    非协同产值单("非协同产值单", "非协同产值单"),
    无合同付款("无合同付款", "无合同付款"),
    经营性业务("经营性业务", "经营性业务"),
    水电费分摊("水电费分摊", "水电费分摊"),
    投资履约("投资履约", "投资履约"),
    费用单("费用单", "费用单"),
    合同("合同", "合同");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BizOrderType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizOrderType fromCode(String code){
        switch(code) {
            case "采购订单":
                return 采购订单;
            case "简易合同":
                return 简易合同;
            case "非现金支付":
                return 非现金支付;
            case "非协同产值单":
                return 非协同产值单;
            case "无合同付款":
                return 无合同付款;
            case "经营性业务":
                return 经营性业务;
            case "水电费分摊":
                return 水电费分摊;
            case "投资履约":
                return 投资履约;
            case "费用单":
                return 费用单;
            case "合同":
                return 合同;
            default:
                return null;
        }
    }
}
