package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_system_type
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
public enum BizSystemType {

    SAP0("SAP0", "SAP 非协同"),
    SAP1("SAP1", "SAP 协同"),
    EAS0("EAS0", "EAS 非协同");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BizSystemType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizSystemType fromCode(String code){
        switch(code) {
            case "SAP0":
                return SAP0;
            case "SAP1":
                return SAP1;
            case "EAS0":
                return EAS0;
            default:
                return null;
        }
    }
}
