package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * documenttype_wk
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
public enum DocumentTypeWk {

    _0("0", "默认"),
    _1("1", "业务单"),
    _2("2", "发票"),
    _9("9", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DocumentTypeWk(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocumentTypeWk fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
