package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * exception_handle_way
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
public enum ExceptionHandleWay {

    _1("1", "退回经办人"),
    _2("2", "退回供应商"),
    _3("3", "转交签收岗"),
    _4("4", "关闭"),
    _0("0", "无");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ExceptionHandleWay(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExceptionHandleWay fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
