package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * red_confirmation_status
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
public enum RedConfirmationStatus {

    _1("1", "已关联"),
    _0("0", "已取消");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RedConfirmationStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedConfirmationStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
