package com.xforceplus.purchaserordersaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_invoice_source
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
public enum TaxInvoiceSource {

    SK("sk", "税控发票"),
    QD("qd", "数电发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxInvoiceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxInvoiceSource fromCode(String code){
        switch(code) {
            case "sk":
                return SK;
            case "qd":
                return QD;
            default:
                return null;
        }
    }
}
