package com.xforceplus.purchaserordersaas.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AntBillDetailItem implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 发票类型
   */
  @TableField("invoiceKind")
  private String invoiceKind;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 商品名称
   */
  @TableField("itemName")
  private String itemName;

  /**
   * 红字/蓝字
   */
  @TableField("redBlueSign")
  private String redBlueSign;

  /**
   * 特殊业务类型
   */
  @TableField("itemTypeCode")
  private String itemTypeCode;

  /**
   * 成品油
   */
  @TableField("hasCpy")
  private String hasCpy;

  /**
   * 税收分类编码
   */
  @TableField("goodsTaxNo")
  private String goodsTaxNo;

  /**
   * 品名简称
   */
  @TableField("itemShortName")
  private String itemShortName;

  /**
   * 免税类型
   */
  @TableField("zeroTax")
  private String zeroTax;

  /**
   * 结算单号
   */
  @TableField("salesbillNo")
  private String salesbillNo;

  /**
   * 结算单类型
   */
  @TableField("businessBillType")
  private String businessBillType;

  /**
   * 单据状态
   */
  private String status;

  /**
   * 购方公司
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 销方公司
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方编号
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 含税总额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 总税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 未开票金额
   */
  @TableField("canMakeAmountWithTax")
  private BigDecimal canMakeAmountWithTax;

  /**
   * 协同标识
   */
  @TableField("cooperateFlag")
  private String cooperateFlag;

  /**
   * 单据类型
   */
  @TableField("salesbillType")
  private String salesbillType;

  /**
   * 发票认证状态
   */
  @TableField("authStatus")
  private String authStatus;

  /**
   * 备注
   */
  private String remark;

  /**
   * 销方开户行
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 购方电话
   */
  @TableField("purchaserTel")
  private String purchaserTel;

  /**
   * 购方银行账号
   */
  @TableField("purchaserBankAccount")
  private String purchaserBankAccount;

  /**
   * 复核人
   */
  @TableField("checkerName")
  private String checkerName;

  /**
   * 发票状态
   */
  @TableField("invoiceStatus")
  private String invoiceStatus;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 销方银行账号
   */
  @TableField("sellerBankAccount")
  private String sellerBankAccount;

  /**
   * 购方地址
   */
  @TableField("purchaserAddress")
  private String purchaserAddress;

  /**
   * 收款人
   */
  @TableField("cashierName")
  private String cashierName;

  /**
   * 销方电话
   */
  @TableField("sellerTel")
  private String sellerTel;

  /**
   * 开票人
   */
  @TableField("invoicerName")
  private String invoicerName;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 购方开户行
   */
  @TableField("purchaserBankName")
  private String purchaserBankName;

  /**
   * 接收方邮箱
   */
  @TableField("receiveUserEmail")
  private String receiveUserEmail;

  /**
   * 税收优惠政策
   */
  @TableField("taxPreCon")
  private String taxPreCon;

  /**
   * 是否享受税收优惠政策
   */
  @TableField("taxPre")
  private String taxPre;

  /**
   * 结算单明细号
   */
  @TableField("salesbillItemNo")
  private String salesbillItemNo;

  /**
   * 价内折扣税额
   */
  @TableField("innerDiscountTax")
  private BigDecimal innerDiscountTax;

  /**
   * 价外折扣税额
   */
  @TableField("outterDiscountTax")
  private BigDecimal outterDiscountTax;

  /**
   * 不含税价外折扣
   */
  @TableField("outterDiscountWithoutTax")
  private BigDecimal outterDiscountWithoutTax;

  /**
   * 含税价外折扣
   */
  @TableField("outterDiscountWithTax")
  private BigDecimal outterDiscountWithTax;

  /**
   * 不含税价内折扣
   */
  @TableField("innerDiscountWithoutTax")
  private BigDecimal innerDiscountWithoutTax;

  /**
   * 含税价内折扣
   */
  @TableField("innerDiscountWithTax")
  private BigDecimal innerDiscountWithTax;

  /**
   * 含税单价
   */
  @TableField("unitPriceWithTax")
  private BigDecimal unitPriceWithTax;

  /**
   * 不含税总额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 单位
   */
  @TableField("quantityUnit")
  private String quantityUnit;

  /**
   * 数量
   */
  private String quantity;

  /**
   * 不含税单价
   */
  @TableField("unitPrice")
  private BigDecimal unitPrice;

  /**
   * 规格型号
   */
  @TableField("itemSpec")
  private String itemSpec;

  /**
   * 国税发票来源
   */
  @TableField("taxInvoiceSource")
  private String taxInvoiceSource;

  /**
   * 购方商品编码
   */
  @TableField("itemCode")
  private String itemCode;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceKind", invoiceKind);
      map.put("taxRate", taxRate);
      map.put("itemName", itemName);
      map.put("redBlueSign", redBlueSign);
      map.put("itemTypeCode", itemTypeCode);
      map.put("hasCpy", hasCpy);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("itemShortName", itemShortName);
      map.put("zeroTax", zeroTax);
      map.put("salesbillNo", salesbillNo);
      map.put("businessBillType", businessBillType);
      map.put("status", status);
      map.put("purchaserName", purchaserName);
      map.put("sellerName", sellerName);
      map.put("sellerNo", sellerNo);
      map.put("amountWithTax", amountWithTax);
      map.put("taxAmount", taxAmount);
      map.put("canMakeAmountWithTax", canMakeAmountWithTax);
      map.put("cooperateFlag", cooperateFlag);
      map.put("salesbillType", salesbillType);
      map.put("authStatus", authStatus);
      map.put("remark", remark);
      map.put("sellerBankName", sellerBankName);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("checkerName", checkerName);
      map.put("invoiceStatus", invoiceStatus);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("purchaserAddress", purchaserAddress);
      map.put("cashierName", cashierName);
      map.put("sellerTel", sellerTel);
      map.put("invoicerName", invoicerName);
      map.put("sellerAddress", sellerAddress);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserBankName", purchaserBankName);
      map.put("receiveUserEmail", receiveUserEmail);
      map.put("taxPreCon", taxPreCon);
      map.put("taxPre", taxPre);
      map.put("salesbillItemNo", salesbillItemNo);
      map.put("innerDiscountTax", innerDiscountTax);
      map.put("outterDiscountTax", outterDiscountTax);
      map.put("outterDiscountWithoutTax", outterDiscountWithoutTax);
      map.put("outterDiscountWithTax", outterDiscountWithTax);
      map.put("innerDiscountWithoutTax", innerDiscountWithoutTax);
      map.put("innerDiscountWithTax", innerDiscountWithTax);
      map.put("unitPriceWithTax", unitPriceWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("quantityUnit", quantityUnit);
      map.put("quantity", quantity);
      map.put("unitPrice", unitPrice);
      map.put("itemSpec", itemSpec);
      map.put("taxInvoiceSource", taxInvoiceSource);
      map.put("itemCode", itemCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static AntBillDetailItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    AntBillDetailItem entity = new AntBillDetailItem();
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceKind((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redBlueSign")) {
      Object obj = map.get("redBlueSign");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedBlueSign((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemTypeCode")) {
      Object obj = map.get("itemTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hasCpy")) {
      Object obj = map.get("hasCpy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHasCpy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemShortName")) {
      Object obj = map.get("itemShortName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemShortName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZeroTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("canMakeAmountWithTax")) {
      Object obj = map.get("canMakeAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCanMakeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCanMakeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCanMakeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCanMakeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCanMakeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cooperateFlag")) {
      Object obj = map.get("cooperateFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCooperateFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillType")) {
      Object obj = map.get("salesbillType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPreCon")) {
      Object obj = map.get("taxPreCon");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPreCon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPre")) {
      Object obj = map.get("taxPre");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPre((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillItemNo")) {
      Object obj = map.get("salesbillItemNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountTax")) {
      Object obj = map.get("innerDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountTax")) {
      Object obj = map.get("outterDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithoutTax")) {
      Object obj = map.get("outterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceKind((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redBlueSign")) {
      Object obj = map.get("redBlueSign");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedBlueSign((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemTypeCode")) {
      Object obj = map.get("itemTypeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hasCpy")) {
      Object obj = map.get("hasCpy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHasCpy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemShortName")) {
      Object obj = map.get("itemShortName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemShortName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZeroTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessBillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("canMakeAmountWithTax")) {
      Object obj = map.get("canMakeAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCanMakeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCanMakeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCanMakeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCanMakeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCanMakeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("cooperateFlag")) {
      Object obj = map.get("cooperateFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCooperateFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesbillType")) {
      Object obj = map.get("salesbillType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCashierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveUserEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxPreCon")) {
      Object obj = map.get("taxPreCon");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPreCon((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxPre")) {
      Object obj = map.get("taxPre");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPre((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesbillItemNo")) {
      Object obj = map.get("salesbillItemNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillItemNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountTax")) {
      Object obj = map.get("innerDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outterDiscountTax")) {
      Object obj = map.get("outterDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOutterDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outterDiscountWithoutTax")) {
      Object obj = map.get("outterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantityUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxInvoiceSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
