package com.xforceplus.purchaserordersaas.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 业务单主对象
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BizOrder implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务单号
   */
  private String bizOrderNo;

  /**
   * 协同标识
   */
  private String cooperateFlag;

  /**
   * 运单号
   */
  private String waybillNumber;

  /**
   * 单据签收时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billSignTime;

  /**
   * 单据签收人
   */
  private String billSignUserName;

  /**
   * 是否合格
   */
  private String isQualified;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 原单据编号
   */
  private String originBizOrderNo;

  /**
   * 销方编号
   */
  private String sellerNo;

  /**
   * 销方名称
   */
  private String sellerName;

  /**
   * 销方税号
   */
  private String sellerTaxNo;

  /**
   * 销方电话
   */
  private String sellerTel;

  /**
   * 销方地址
   */
  private String sellerAddress;

  /**
   * 销方银行名称
   */
  private String sellerBankName;

  /**
   * 销方银行账户
   */
  private String sellerBankAccount;

  /**
   * 销方租户id
   */
  private Long sellerTenantId;

  /**
   * 销方公司id
   */
  private Long sellerId;

  /**
   * 购方公司编号
   */
  private String purchaserNo;

  /**
   * 购方名称
   */
  private String purchaserName;

  /**
   * 购方税号
   */
  private String purchaserTaxNo;

  /**
   * 购方电话
   */
  private String purchaserTel;

  /**
   * 购方地址
   */
  private String purchaserAddress;

  /**
   * 购方银行名称
   */
  private String purchaserBankName;

  /**
   * 购方公司id
   */
  private Long purchaserId;

  /**
   * AR/AP类型
   */
  private String businessBillType;

  /**
   * 国税发票来源
   */
  private String taxInvoiceSource;

  /**
   * 系统来源
   */
  private String systemOrig;

  /**
   * 业务单据类型
   */
  private String bizOrderType;

  /**
   * 票据类型
   */
  private String receiptType;

  /**
   * 计价方式
   */
  private String priceMethod;

  /**
   * 单据含税金额
   */
  private BigDecimal amountWithTax;

  /**
   * 单据不含税金额
   */
  private BigDecimal amountWithoutTax;

  /**
   * 单据税额
   */
  private BigDecimal taxAmount;

  /**
   * 原始金额
   */
  private BigDecimal originAmount;

  /**
   * 已开含税金额
   */
  private BigDecimal alreadyMakeAmountWithTax;

  /**
   * 已开不含税金额
   */
  private BigDecimal alreadyMakeAmountWithoutTax;

  /**
   * 已开税额
   */
  private BigDecimal alreadyMakeAmountTaxAmount;

  /**
   * 作废发票不释放含税金额
   */
  private BigDecimal abandonFreezeAmountWithTax;

  /**
   * 作废发票不释放不含税金额
   */
  private BigDecimal abandonFreezeAmountWithoutTax;

  /**
   * 作废发票不释放税额
   */
  private BigDecimal abandonFreezeAmountTaxAmount;

  /**
   * 折扣含税总额
   */
  private BigDecimal discountWithTaxTotal;

  /**
   * 折扣不含税总额
   */
  private BigDecimal discountWithoutTaxTotal;

  /**
   * 折扣总额税额
   */
  private BigDecimal discountTaxAmountTotal;

  /**
   * 价外含税折扣
   */
  private BigDecimal outterDiscountWithTax;

  /**
   * 价外不含税折扣
   */
  private BigDecimal outterDiscountWithoutTax;

  /**
   * 价内含税折扣
   */
  private BigDecimal innerDiscountWithTax;

  /**
   * 价内不含税折扣
   */
  private BigDecimal innerDiscountWithoutTax;

  /**
   * 价外预付卡含税金额
   */
  private BigDecimal outterPrepayAmountWithTax;

  /**
   * 价外预付卡不含税金额
   */
  private BigDecimal outterPrepayAmountWithoutTax;

  /**
   * 价内预付卡含税金额
   */
  private BigDecimal innerPrepayAmountWithTax;

  /**
   * 价内预付卡不含税金额
   */
  private BigDecimal innerPrepayAmountWithoutTax;

  /**
   * 上传方确认标识
   */
  private String uploadConfirmFlag;

  /**
   * 接收方确认标识
   */
  private String receiveConfirmFlag;

  /**
   * 开票状态
   */
  private String makeoutStatus;

  /**
   * 单据状态
   */
  private String status;

  /**
   * 业务单修改标记
   */
  private Long modifyMark;

  /**
   * 是否被修改过
   */
  private String cooperateModifyStatus;

  /**
   * 原始发票号码
   */
  private String originInvoiceNo;

  /**
   * 原始发票代码
   */
  private String originInvoiceCode;

  /**
   * 原蓝票发票类型
   */
  private String originInvoiceType;

  /**
   * 原蓝票的开票日期
   */
  private String originPaperDrawDate;

  /**
   * 红字信息编号
   */
  private String redNotification;

  /**
   * 复核人
   */
  private String checkerName;

  /**
   * 付款人
   */
  private String cashierName;

  /**
   * 开票人
   */
  private String invoicerName;

  /**
   * 接收方邮箱
   */
  private String receiveUserEmail;

  /**
   * 接收方电话
   */
  private String receiveUserTel;

  /**
   * 组织机构id
   */
  private Long sysOrgId;

  /**
   * 使用状态
   */
  private String usingStatus;

  /**
   * 客户数据编号
   */
  private String customerNo;

  /**
   * 物流-收件人
   */
  private String addressee;

  /**
   * 物流-收件人电话
   */
  private String addresseeTel;

  /**
   * 物流-收件人省份
   */
  private String addresseeProvince;

  /**
   * 物流-收件人城市
   */
  private String addresseeCity;

  /**
   * 物流-收件人所在县区
   */
  private String addresseeCounty;

  /**
   * 物流-收件人地址
   */
  private String direction;

  /**
   * 发票类型
   */
  private String invoiceType;

  /**
   * 物流备注
   */
  private String logisticRemark;

  /**
   * 备注
   */
  private String remark;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 扩展字段6
   */
  private String ext6;

  /**
   * 扩展字段7
   */
  private String ext7;

  /**
   * 扩展字段8
   */
  private String ext8;

  /**
   * 扩展字段9
   */
  private String ext9;

  /**
   * 扩展字段10
   */
  private String ext10;

  /**
   * 扩展字段11
   */
  private String ext11;

  /**
   * 扩展字段12
   */
  private String ext12;

  /**
   * 扩展字段13
   */
  private String ext13;

  /**
   * 扩展字段14
   */
  private String ext14;

  /**
   * 扩展字段15
   */
  private String ext15;

  /**
   * 扩展字段16
   */
  private String ext16;

  /**
   * 扩展字段17
   */
  private String ext17;

  /**
   * 扩展字段18
   */
  private String ext18;

  /**
   * 扩展字段19
   */
  private String ext19;

  /**
   * 扩展字段20
   */
  private String ext20;

  /**
   * 扩展字段21
   */
  private String ext21;

  /**
   * 扩展字段22
   */
  private String ext22;

  /**
   * 扩展字段23
   */
  private String ext23;

  /**
   * 扩展字段24
   */
  private String ext24;

  /**
   * 扩展字段25
   */
  private String ext25;

  /**
   * 审批状态
   */
  private String auditStatus;

  /**
   * 系统来源类型
   */
  private String systemOrigType;

  /**
   * 作废申请标识
   */
  private String applyInvalidFlag;

  /**
   * 匹配状态
   */
  private String matchStatus;

  /**
   * 开具原因
   */
  private String makingReason;

  /**
   * 导入的批次号
   */
  private String importBatchNo;

  /**
   * 小票日期
   */
  private String posDate;

  /**
   * 渠道,中间商租户id
   */
  private Long channel;

  /**
   * 业务单失败原因
   */
  private String processRemark;

  /**
   * 购方类型
   */
  private String purchaserType;

  /**
   * 审核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime auditTime;

  /**
   * 抵扣状态
   */
  private String authStatus;

  /**
   * 勾选时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkTime;

  /**
   * 抵扣时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authTime;

  /**
   * 单据识别状态
   */
  private String recogStatus;

  /**
   * 识别时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime recogTime;

  /**
   * 是否需要抵扣
   */
  private String isNeedAuth;

  /**
   * 可抵扣税额
   */
  private BigDecimal effectiveTaxAmount;

  /**
   * 异常类型
   */
  private String exceptionType;

  /**
   * 异常说明
   */
  private String exceptionRemark;

  /**
   * 邮包签收时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime parcelSignTime;

  /**
   * 邮包签收人
   */
  private String parcelSignUserName;

  /**
   * 作废唯一标识
   */
  private Long deleteToken;

  /**
   * 销方组织代码
   */
  private String sellerOrgCode;

  /**
   * 购方组织代码
   */
  private String purchaserOrgCode;

  /**
   * 审核人
   */
  private String auditName;

  /**
   * 购方银行账户
   */
  private String purchaserBankAccount;

  /**
   * 勾选状态
   */
  private String checkStatus;

  /**
   * 税率
   */
  private String taxRate;

  /**
   * 开票时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime makeoutTime;

  /**
   * 自校验状态
   */
  private String autoCheckStatus;

  /**
   * 结算单号
   */
  private String settlementNo;

  /**
   * 上传日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime uploadTime;

  /**
   * 外部业务单ID
   */
  private Long externalBizOrderId;

  /**
   * 扩展字段26
   */
  private String ext26;

  /**
   * 扩展字段27
   */
  private String ext27;

  /**
   * 扩展字段28
   */
  private String ext28;

  /**
   * 扩展字段29
   */
  private String ext29;

  /**
   * 扩展字段30
   */
  private String ext30;

  /**
   * 扩展字段31
   */
  private String ext31;

  /**
   * 扩展字段32
   */
  private String ext32;

  /**
   * 扩展字段33
   */
  private String ext33;

  /**
   * 扩展字段34
   */
  private String ext34;

  /**
   * 扩展字段35
   */
  private String ext35;

  /**
   * 扩展字段36
   */
  private String ext36;

  /**
   * 扩展字段37
   */
  private String ext37;

  /**
   * 扩展字段38
   */
  private String ext38;

  /**
   * 扩展字段39
   */
  private String ext39;

  /**
   * 扩展字段40
   */
  private String ext40;

  /**
   * 自校验说明
   */
  private String autoCheckNote;

  /**
   * 自校验时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime autoCheckTime;

  /**
   * 迁移标记
   */
  private String transferTag;

  /**
   * 扫描重扫标记
   */
  private String scanBackFlag;

  /**
   * 匹配批次号
   */
  private String matchBatchNo;

  /**
   * 红字确认单关联状态
   */
  private String redRelationStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("biz_order_no", bizOrderNo);
      map.put("cooperate_flag", cooperateFlag);
      map.put("waybill_number", waybillNumber);
      map.put("bill_sign_time", BocpGenUtils.toTimestamp(billSignTime));
      map.put("bill_sign_user_name", billSignUserName);
      map.put("is_qualified", isQualified);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("origin_biz_order_no", originBizOrderNo);
      map.put("seller_no", sellerNo);
      map.put("seller_name", sellerName);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("seller_tel", sellerTel);
      map.put("seller_address", sellerAddress);
      map.put("seller_bank_name", sellerBankName);
      map.put("seller_bank_account", sellerBankAccount);
      map.put("seller_tenant_id", sellerTenantId);
      map.put("seller_id", sellerId);
      map.put("purchaser_no", purchaserNo);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("purchaser_tel", purchaserTel);
      map.put("purchaser_address", purchaserAddress);
      map.put("purchaser_bank_name", purchaserBankName);
      map.put("purchaser_id", purchaserId);
      map.put("business_bill_type", businessBillType);
      map.put("tax_invoice_source", taxInvoiceSource);
      map.put("system_orig", systemOrig);
      map.put("biz_order_type", bizOrderType);
      map.put("receipt_type", receiptType);
      map.put("price_method", priceMethod);
      map.put("amount_with_tax", amountWithTax);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("origin_amount", originAmount);
      map.put("already_make_amount_with_tax", alreadyMakeAmountWithTax);
      map.put("already_make_amount_without_tax", alreadyMakeAmountWithoutTax);
      map.put("already_make_amount_tax_amount", alreadyMakeAmountTaxAmount);
      map.put("abandon_freeze_amount_with_tax", abandonFreezeAmountWithTax);
      map.put("abandon_freeze_amount_without_tax", abandonFreezeAmountWithoutTax);
      map.put("abandon_freeze_amount_tax_amount", abandonFreezeAmountTaxAmount);
      map.put("discount_with_tax_total", discountWithTaxTotal);
      map.put("discount_without_tax_total", discountWithoutTaxTotal);
      map.put("discount_tax_amount_total", discountTaxAmountTotal);
      map.put("outter_discount_with_tax", outterDiscountWithTax);
      map.put("outter_discount_without_tax", outterDiscountWithoutTax);
      map.put("inner_discount_with_tax", innerDiscountWithTax);
      map.put("inner_discount_without_tax", innerDiscountWithoutTax);
      map.put("outter_prepay_amount_with_tax", outterPrepayAmountWithTax);
      map.put("outter_prepay_amount_without_tax", outterPrepayAmountWithoutTax);
      map.put("inner_prepay_amount_with_tax", innerPrepayAmountWithTax);
      map.put("inner_prepay_amount_without_tax", innerPrepayAmountWithoutTax);
      map.put("upload_confirm_flag", uploadConfirmFlag);
      map.put("receive_confirm_flag", receiveConfirmFlag);
      map.put("makeout_status", makeoutStatus);
      map.put("status", status);
      map.put("modify_mark", modifyMark);
      map.put("cooperate_modify_status", cooperateModifyStatus);
      map.put("origin_invoice_no", originInvoiceNo);
      map.put("origin_invoice_code", originInvoiceCode);
      map.put("origin_invoice_type", originInvoiceType);
      map.put("origin_paper_draw_date", originPaperDrawDate);
      map.put("red_notification", redNotification);
      map.put("checker_name", checkerName);
      map.put("cashier_name", cashierName);
      map.put("invoicer_name", invoicerName);
      map.put("receive_user_email", receiveUserEmail);
      map.put("receive_user_tel", receiveUserTel);
      map.put("sys_org_id", sysOrgId);
      map.put("using_status", usingStatus);
      map.put("customer_no", customerNo);
      map.put("addressee", addressee);
      map.put("addressee_tel", addresseeTel);
      map.put("addressee_province", addresseeProvince);
      map.put("addressee_city", addresseeCity);
      map.put("addressee_county", addresseeCounty);
      map.put("direction", direction);
      map.put("invoice_type", invoiceType);
      map.put("logistic_remark", logisticRemark);
      map.put("remark", remark);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("ext11", ext11);
      map.put("ext12", ext12);
      map.put("ext13", ext13);
      map.put("ext14", ext14);
      map.put("ext15", ext15);
      map.put("ext16", ext16);
      map.put("ext17", ext17);
      map.put("ext18", ext18);
      map.put("ext19", ext19);
      map.put("ext20", ext20);
      map.put("ext21", ext21);
      map.put("ext22", ext22);
      map.put("ext23", ext23);
      map.put("ext24", ext24);
      map.put("ext25", ext25);
      map.put("audit_status", auditStatus);
      map.put("system_orig_type", systemOrigType);
      map.put("apply_invalid_flag", applyInvalidFlag);
      map.put("match_status", matchStatus);
      map.put("making_reason", makingReason);
      map.put("import_batch_no", importBatchNo);
      map.put("pos_date", posDate);
      map.put("channel", channel);
      map.put("process_remark", processRemark);
      map.put("purchaser_type", purchaserType);
      map.put("audit_time", BocpGenUtils.toTimestamp(auditTime));
      map.put("auth_status", authStatus);
      map.put("check_time", BocpGenUtils.toTimestamp(checkTime));
      map.put("auth_time", BocpGenUtils.toTimestamp(authTime));
      map.put("recog_status", recogStatus);
      map.put("recog_time", BocpGenUtils.toTimestamp(recogTime));
      map.put("is_need_auth", isNeedAuth);
      map.put("effective_tax_amount", effectiveTaxAmount);
      map.put("exception_type", exceptionType);
      map.put("exception_remark", exceptionRemark);
      map.put("parcel_sign_time", BocpGenUtils.toTimestamp(parcelSignTime));
      map.put("parcel_sign_user_name", parcelSignUserName);
      map.put("delete_token", deleteToken);
      map.put("seller_org_code", sellerOrgCode);
      map.put("purchaser_org_code", purchaserOrgCode);
      map.put("audit_name", auditName);
      map.put("purchaser_bank_account", purchaserBankAccount);
      map.put("check_status", checkStatus);
      map.put("tax_rate", taxRate);
      map.put("makeout_time", BocpGenUtils.toTimestamp(makeoutTime));
      map.put("auto_check_status", autoCheckStatus);
      map.put("settlement_no", settlementNo);
      map.put("upload_time", BocpGenUtils.toTimestamp(uploadTime));
      map.put("external_biz_order_id", externalBizOrderId);
      map.put("ext26", ext26);
      map.put("ext27", ext27);
      map.put("ext28", ext28);
      map.put("ext29", ext29);
      map.put("ext30", ext30);
      map.put("ext31", ext31);
      map.put("ext32", ext32);
      map.put("ext33", ext33);
      map.put("ext34", ext34);
      map.put("ext35", ext35);
      map.put("ext36", ext36);
      map.put("ext37", ext37);
      map.put("ext38", ext38);
      map.put("ext39", ext39);
      map.put("ext40", ext40);
      map.put("auto_check_note", autoCheckNote);
      map.put("auto_check_time", BocpGenUtils.toTimestamp(autoCheckTime));
      map.put("transfer_tag", transferTag);
      map.put("scan_back_flag", scanBackFlag);
      map.put("match_batch_no", matchBatchNo);
      map.put("red_relation_status", redRelationStatus);

      return map;
  }

  public static BizOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BizOrder entity = new BizOrder();
    if(map.containsKey("biz_order_no")) {
      Object obj = map.get("biz_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cooperate_flag")) {
      Object obj = map.get("cooperate_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCooperateFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("waybill_number")) {
      Object obj = map.get("waybill_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWaybillNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_sign_time")) {
      Object obj = map.get("bill_sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillSignTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillSignTime(null);
      }
    }
    if(map.containsKey("bill_sign_user_name")) {
      Object obj = map.get("bill_sign_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillSignUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_qualified")) {
      Object obj = map.get("is_qualified");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsQualified((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_biz_order_no")) {
      Object obj = map.get("origin_biz_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("seller_id")) {
      Object obj = map.get("seller_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_id")) {
      Object obj = map.get("purchaser_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("business_bill_type")) {
      Object obj = map.get("business_bill_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_invoice_source")) {
      Object obj = map.get("tax_invoice_source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_orig")) {
      Object obj = map.get("system_orig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_order_type")) {
      Object obj = map.get("biz_order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receipt_type")) {
      Object obj = map.get("receipt_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiptType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("price_method")) {
      Object obj = map.get("price_method");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPriceMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("origin_amount")) {
      Object obj = map.get("origin_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOriginAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOriginAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOriginAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOriginAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOriginAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("already_make_amount_with_tax")) {
      Object obj = map.get("already_make_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMakeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlreadyMakeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("already_make_amount_without_tax")) {
      Object obj = map.get("already_make_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMakeAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlreadyMakeAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("already_make_amount_tax_amount")) {
      Object obj = map.get("already_make_amount_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMakeAmountTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMakeAmountTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMakeAmountTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlreadyMakeAmountTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMakeAmountTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("abandon_freeze_amount_with_tax")) {
      Object obj = map.get("abandon_freeze_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAbandonFreezeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAbandonFreezeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAbandonFreezeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAbandonFreezeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAbandonFreezeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("abandon_freeze_amount_without_tax")) {
      Object obj = map.get("abandon_freeze_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAbandonFreezeAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAbandonFreezeAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAbandonFreezeAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAbandonFreezeAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAbandonFreezeAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("abandon_freeze_amount_tax_amount")) {
      Object obj = map.get("abandon_freeze_amount_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAbandonFreezeAmountTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAbandonFreezeAmountTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAbandonFreezeAmountTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAbandonFreezeAmountTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAbandonFreezeAmountTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discount_with_tax_total")) {
      Object obj = map.get("discount_with_tax_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountWithTaxTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountWithTaxTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountWithTaxTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountWithTaxTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountWithTaxTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discount_without_tax_total")) {
      Object obj = map.get("discount_without_tax_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountWithoutTaxTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountWithoutTaxTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountWithoutTaxTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountWithoutTaxTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountWithoutTaxTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discount_tax_amount_total")) {
      Object obj = map.get("discount_tax_amount_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountTaxAmountTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountTaxAmountTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountTaxAmountTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountTaxAmountTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountTaxAmountTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outter_discount_with_tax")) {
      Object obj = map.get("outter_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outter_discount_without_tax")) {
      Object obj = map.get("outter_discount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("inner_discount_with_tax")) {
      Object obj = map.get("inner_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("inner_discount_without_tax")) {
      Object obj = map.get("inner_discount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outter_prepay_amount_with_tax")) {
      Object obj = map.get("outter_prepay_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterPrepayAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterPrepayAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterPrepayAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterPrepayAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterPrepayAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outter_prepay_amount_without_tax")) {
      Object obj = map.get("outter_prepay_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterPrepayAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterPrepayAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterPrepayAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterPrepayAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterPrepayAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("inner_prepay_amount_with_tax")) {
      Object obj = map.get("inner_prepay_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerPrepayAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerPrepayAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerPrepayAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerPrepayAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerPrepayAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("inner_prepay_amount_without_tax")) {
      Object obj = map.get("inner_prepay_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerPrepayAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerPrepayAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerPrepayAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerPrepayAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerPrepayAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("upload_confirm_flag")) {
      Object obj = map.get("upload_confirm_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUploadConfirmFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receive_confirm_flag")) {
      Object obj = map.get("receive_confirm_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveConfirmFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeout_status")) {
      Object obj = map.get("makeout_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMakeoutStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("modify_mark")) {
      Object obj = map.get("modify_mark");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setModifyMark((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setModifyMark(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setModifyMark(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cooperate_modify_status")) {
      Object obj = map.get("cooperate_modify_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCooperateModifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_type")) {
      Object obj = map.get("origin_invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_paper_draw_date")) {
      Object obj = map.get("origin_paper_draw_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginPaperDrawDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_notification")) {
      Object obj = map.get("red_notification");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedNotification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receive_user_email")) {
      Object obj = map.get("receive_user_email");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receive_user_tel")) {
      Object obj = map.get("receive_user_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveUserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sys_org_id")) {
      Object obj = map.get("sys_org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSysOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSysOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSysOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("using_status")) {
      Object obj = map.get("using_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUsingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_no")) {
      Object obj = map.get("customer_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddressee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee_tel")) {
      Object obj = map.get("addressee_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee_province")) {
      Object obj = map.get("addressee_province");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee_city")) {
      Object obj = map.get("addressee_city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee_county")) {
      Object obj = map.get("addressee_county");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeCounty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDirection((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistic_remark")) {
      Object obj = map.get("logistic_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt20((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt21((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt22((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt23((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt24((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt25((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_orig_type")) {
      Object obj = map.get("system_orig_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystemOrigType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apply_invalid_flag")) {
      Object obj = map.get("apply_invalid_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyInvalidFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("making_reason")) {
      Object obj = map.get("making_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMakingReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("import_batch_no")) {
      Object obj = map.get("import_batch_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImportBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pos_date")) {
      Object obj = map.get("pos_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPosDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChannel((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChannel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChannel(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("process_remark")) {
      Object obj = map.get("process_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcessRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_type")) {
      Object obj = map.get("purchaser_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuditTime(null);
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckTime(null);
      }
    }
    if(map.containsKey("auth_time")) {
      Object obj = map.get("auth_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuthTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthTime(null);
      }
    }
    if(map.containsKey("recog_status")) {
      Object obj = map.get("recog_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_time")) {
      Object obj = map.get("recog_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecogTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRecogTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecogTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRecogTime(null);
      }
    }
    if(map.containsKey("is_need_auth")) {
      Object obj = map.get("is_need_auth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsNeedAuth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("exception_type")) {
      Object obj = map.get("exception_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_remark")) {
      Object obj = map.get("exception_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parcel_sign_time")) {
      Object obj = map.get("parcel_sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setParcelSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setParcelSignTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setParcelSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setParcelSignTime(null);
      }
    }
    if(map.containsKey("parcel_sign_user_name")) {
      Object obj = map.get("parcel_sign_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setParcelSignUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_token")) {
      Object obj = map.get("delete_token");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeleteToken((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeleteToken(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeleteToken(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("seller_org_code")) {
      Object obj = map.get("seller_org_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_org_code")) {
      Object obj = map.get("purchaser_org_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_name")) {
      Object obj = map.get("audit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_status")) {
      Object obj = map.get("check_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeout_time")) {
      Object obj = map.get("makeout_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMakeoutTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setMakeoutTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMakeoutTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMakeoutTime(null);
      }
    }
    if(map.containsKey("auto_check_status")) {
      Object obj = map.get("auto_check_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAutoCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("upload_time")) {
      Object obj = map.get("upload_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUploadTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUploadTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUploadTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUploadTime(null);
      }
    }
    if(map.containsKey("external_biz_order_id")) {
      Object obj = map.get("external_biz_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExternalBizOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExternalBizOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExternalBizOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ext26")) {
      Object obj = map.get("ext26");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt26((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext27")) {
      Object obj = map.get("ext27");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt27((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext28")) {
      Object obj = map.get("ext28");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt28((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext29")) {
      Object obj = map.get("ext29");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt29((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext30")) {
      Object obj = map.get("ext30");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt30((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext31")) {
      Object obj = map.get("ext31");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt31((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext32")) {
      Object obj = map.get("ext32");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt32((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext33")) {
      Object obj = map.get("ext33");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt33((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext34")) {
      Object obj = map.get("ext34");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt34((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext35")) {
      Object obj = map.get("ext35");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt35((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext36")) {
      Object obj = map.get("ext36");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt36((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext37")) {
      Object obj = map.get("ext37");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt37((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext38")) {
      Object obj = map.get("ext38");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt38((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext39")) {
      Object obj = map.get("ext39");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt39((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext40")) {
      Object obj = map.get("ext40");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt40((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auto_check_note")) {
      Object obj = map.get("auto_check_note");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAutoCheckNote((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auto_check_time")) {
      Object obj = map.get("auto_check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAutoCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAutoCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAutoCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAutoCheckTime(null);
      }
    }
    if(map.containsKey("transfer_tag")) {
      Object obj = map.get("transfer_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransferTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scan_back_flag")) {
      Object obj = map.get("scan_back_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setScanBackFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_batch_no")) {
      Object obj = map.get("match_batch_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_relation_status")) {
      Object obj = map.get("red_relation_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedRelationStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("biz_order_no")) {
      Object obj = map.get("biz_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cooperate_flag")) {
      Object obj = map.get("cooperate_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCooperateFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("waybill_number")) {
      Object obj = map.get("waybill_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWaybillNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_sign_time")) {
      Object obj = map.get("bill_sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBillSignTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBillSignTime(null);
      }
    }
    if(map.containsKey("bill_sign_user_name")) {
      Object obj = map.get("bill_sign_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillSignUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_qualified")) {
      Object obj = map.get("is_qualified");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsQualified((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_biz_order_no")) {
      Object obj = map.get("origin_biz_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("seller_id")) {
      Object obj = map.get("seller_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_id")) {
      Object obj = map.get("purchaser_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchaserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("business_bill_type")) {
      Object obj = map.get("business_bill_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessBillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_invoice_source")) {
      Object obj = map.get("tax_invoice_source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxInvoiceSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("system_orig")) {
      Object obj = map.get("system_orig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSystemOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_order_type")) {
      Object obj = map.get("biz_order_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receipt_type")) {
      Object obj = map.get("receipt_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiptType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("price_method")) {
      Object obj = map.get("price_method");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPriceMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("origin_amount")) {
      Object obj = map.get("origin_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOriginAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOriginAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOriginAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOriginAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOriginAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("already_make_amount_with_tax")) {
      Object obj = map.get("already_make_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyMakeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlreadyMakeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyMakeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("already_make_amount_without_tax")) {
      Object obj = map.get("already_make_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyMakeAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlreadyMakeAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("already_make_amount_tax_amount")) {
      Object obj = map.get("already_make_amount_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyMakeAmountTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyMakeAmountTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyMakeAmountTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlreadyMakeAmountTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyMakeAmountTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("abandon_freeze_amount_with_tax")) {
      Object obj = map.get("abandon_freeze_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAbandonFreezeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAbandonFreezeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAbandonFreezeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAbandonFreezeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAbandonFreezeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("abandon_freeze_amount_without_tax")) {
      Object obj = map.get("abandon_freeze_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAbandonFreezeAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAbandonFreezeAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAbandonFreezeAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAbandonFreezeAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAbandonFreezeAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("abandon_freeze_amount_tax_amount")) {
      Object obj = map.get("abandon_freeze_amount_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAbandonFreezeAmountTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAbandonFreezeAmountTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAbandonFreezeAmountTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAbandonFreezeAmountTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAbandonFreezeAmountTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discount_with_tax_total")) {
      Object obj = map.get("discount_with_tax_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountWithTaxTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountWithTaxTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountWithTaxTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountWithTaxTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountWithTaxTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discount_without_tax_total")) {
      Object obj = map.get("discount_without_tax_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountWithoutTaxTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountWithoutTaxTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountWithoutTaxTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountWithoutTaxTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountWithoutTaxTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discount_tax_amount_total")) {
      Object obj = map.get("discount_tax_amount_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountTaxAmountTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountTaxAmountTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountTaxAmountTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountTaxAmountTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountTaxAmountTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outter_discount_with_tax")) {
      Object obj = map.get("outter_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outter_discount_without_tax")) {
      Object obj = map.get("outter_discount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("inner_discount_with_tax")) {
      Object obj = map.get("inner_discount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("inner_discount_without_tax")) {
      Object obj = map.get("inner_discount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outter_prepay_amount_with_tax")) {
      Object obj = map.get("outter_prepay_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterPrepayAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterPrepayAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterPrepayAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOutterPrepayAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterPrepayAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outter_prepay_amount_without_tax")) {
      Object obj = map.get("outter_prepay_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterPrepayAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterPrepayAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterPrepayAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOutterPrepayAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterPrepayAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("inner_prepay_amount_with_tax")) {
      Object obj = map.get("inner_prepay_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerPrepayAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerPrepayAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerPrepayAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerPrepayAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerPrepayAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("inner_prepay_amount_without_tax")) {
      Object obj = map.get("inner_prepay_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerPrepayAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerPrepayAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerPrepayAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerPrepayAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerPrepayAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("upload_confirm_flag")) {
      Object obj = map.get("upload_confirm_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUploadConfirmFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receive_confirm_flag")) {
      Object obj = map.get("receive_confirm_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveConfirmFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("makeout_status")) {
      Object obj = map.get("makeout_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMakeoutStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("modify_mark")) {
      Object obj = map.get("modify_mark");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setModifyMark((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setModifyMark(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setModifyMark(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("cooperate_modify_status")) {
      Object obj = map.get("cooperate_modify_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCooperateModifyStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_type")) {
      Object obj = map.get("origin_invoice_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_paper_draw_date")) {
      Object obj = map.get("origin_paper_draw_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginPaperDrawDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("red_notification")) {
      Object obj = map.get("red_notification");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedNotification((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCashierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receive_user_email")) {
      Object obj = map.get("receive_user_email");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveUserEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receive_user_tel")) {
      Object obj = map.get("receive_user_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveUserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sys_org_id")) {
      Object obj = map.get("sys_org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSysOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSysOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSysOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("using_status")) {
      Object obj = map.get("using_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUsingStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_no")) {
      Object obj = map.get("customer_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddressee((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addressee_tel")) {
      Object obj = map.get("addressee_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addressee_province")) {
      Object obj = map.get("addressee_province");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeProvince((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addressee_city")) {
      Object obj = map.get("addressee_city");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addressee_county")) {
      Object obj = map.get("addressee_county");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeCounty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDirection((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistic_remark")) {
      Object obj = map.get("logistic_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt11((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt12((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt13((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt14((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt15((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt16((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt17((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt18((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt19((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt20((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt21((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt22((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt23((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt24((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt25((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("system_orig_type")) {
      Object obj = map.get("system_orig_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSystemOrigType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("apply_invalid_flag")) {
      Object obj = map.get("apply_invalid_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyInvalidFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatchStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("making_reason")) {
      Object obj = map.get("making_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMakingReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("import_batch_no")) {
      Object obj = map.get("import_batch_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImportBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pos_date")) {
      Object obj = map.get("pos_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPosDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setChannel((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChannel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setChannel(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("process_remark")) {
      Object obj = map.get("process_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcessRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_type")) {
      Object obj = map.get("purchaser_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuditTime(null);
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCheckTime(null);
      }
    }
    if(map.containsKey("auth_time")) {
      Object obj = map.get("auth_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuthTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuthTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuthTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuthTime(null);
      }
    }
    if(map.containsKey("recog_status")) {
      Object obj = map.get("recog_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_time")) {
      Object obj = map.get("recog_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRecogTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRecogTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRecogTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRecogTime(null);
      }
    }
    if(map.containsKey("is_need_auth")) {
      Object obj = map.get("is_need_auth");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsNeedAuth((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("exception_type")) {
      Object obj = map.get("exception_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_remark")) {
      Object obj = map.get("exception_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("parcel_sign_time")) {
      Object obj = map.get("parcel_sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setParcelSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setParcelSignTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setParcelSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setParcelSignTime(null);
      }
    }
    if(map.containsKey("parcel_sign_user_name")) {
      Object obj = map.get("parcel_sign_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setParcelSignUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_token")) {
      Object obj = map.get("delete_token");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeleteToken((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeleteToken(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDeleteToken(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("seller_org_code")) {
      Object obj = map.get("seller_org_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_org_code")) {
      Object obj = map.get("purchaser_org_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_name")) {
      Object obj = map.get("audit_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_status")) {
      Object obj = map.get("check_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("makeout_time")) {
      Object obj = map.get("makeout_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMakeoutTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setMakeoutTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMakeoutTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setMakeoutTime(null);
      }
    }
    if(map.containsKey("auto_check_status")) {
      Object obj = map.get("auto_check_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAutoCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("upload_time")) {
      Object obj = map.get("upload_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUploadTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUploadTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUploadTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUploadTime(null);
      }
    }
    if(map.containsKey("external_biz_order_id")) {
      Object obj = map.get("external_biz_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExternalBizOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExternalBizOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setExternalBizOrderId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("ext26")) {
      Object obj = map.get("ext26");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt26((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext27")) {
      Object obj = map.get("ext27");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt27((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext28")) {
      Object obj = map.get("ext28");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt28((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext29")) {
      Object obj = map.get("ext29");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt29((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext30")) {
      Object obj = map.get("ext30");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt30((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext31")) {
      Object obj = map.get("ext31");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt31((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext32")) {
      Object obj = map.get("ext32");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt32((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext33")) {
      Object obj = map.get("ext33");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt33((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext34")) {
      Object obj = map.get("ext34");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt34((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext35")) {
      Object obj = map.get("ext35");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt35((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext36")) {
      Object obj = map.get("ext36");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt36((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext37")) {
      Object obj = map.get("ext37");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt37((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext38")) {
      Object obj = map.get("ext38");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt38((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext39")) {
      Object obj = map.get("ext39");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt39((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext40")) {
      Object obj = map.get("ext40");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt40((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auto_check_note")) {
      Object obj = map.get("auto_check_note");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAutoCheckNote((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auto_check_time")) {
      Object obj = map.get("auto_check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAutoCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAutoCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAutoCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAutoCheckTime(null);
      }
    }
    if(map.containsKey("transfer_tag")) {
      Object obj = map.get("transfer_tag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransferTag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scan_back_flag")) {
      Object obj = map.get("scan_back_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setScanBackFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("match_batch_no")) {
      Object obj = map.get("match_batch_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatchBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("red_relation_status")) {
      Object obj = map.get("red_relation_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedRelationStatus((String)obj);
        }
      } else {
      }
    }
  }
}
