package com.xforceplus.purchaserordersaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 风险单据对象
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BizOrderException implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务单号
   */
  private String bizOrderNo;

  /**
   * 业务单Id
   */
  private Long bizOrderId;

  /**
   * 业务单据类型
   */
  private String bizOrderType;

  /**
   * 发票类型
   */
  private String invoiceType;

  /**
   * 异常类型
   */
  private String exceptionType;

  /**
   * 异常说明
   */
  private String exceptionRemark;

  /**
   * 异常提交人
   */
  private String exceptionSubmitUserName;

  /**
   * 异常时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime exceptionTime;

  /**
   * 异常处理人
   */
  private String exceptionHandleUserName;

  /**
   * 异常处理时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime exceptionHandleTime;

  /**
   * 异常处理说明
   */
  private String exceptionHandleRemark;

  /**
   * 异常处理方式
   */
  private String exceptionHandleWay;

  /**
   * 退回类型
   */
  private String returnType;

  /**
   * 是否需要物流
   */
  private String needExpress;

  /**
   * 处理状态
   */
  private String handleStatus;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 运单号
   */
  private String waybillNumber;

  /**
   * 经办人邮箱
   */
  private String agentEmail;

  /**
   * 退回的物流单号
   */
  private String backExpressNumber;

  /**
   * 退回联次
   */
  private String returnBatch;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("biz_order_no", bizOrderNo);
      map.put("biz_order_id", bizOrderId);
      map.put("biz_order_type", bizOrderType);
      map.put("invoice_type", invoiceType);
      map.put("exception_type", exceptionType);
      map.put("exception_remark", exceptionRemark);
      map.put("exception_submit_user_name", exceptionSubmitUserName);
      map.put("exception_time", BocpGenUtils.toTimestamp(exceptionTime));
      map.put("exception_handle_user_name", exceptionHandleUserName);
      map.put("exception_handle_time", BocpGenUtils.toTimestamp(exceptionHandleTime));
      map.put("exception_handle_remark", exceptionHandleRemark);
      map.put("exception_handle_way", exceptionHandleWay);
      map.put("return_type", returnType);
      map.put("need_express", needExpress);
      map.put("handle_status", handleStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("waybill_number", waybillNumber);
      map.put("agent_email", agentEmail);
      map.put("back_express_number", backExpressNumber);
      map.put("return_batch", returnBatch);

      return map;
  }

  public static BizOrderException fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BizOrderException entity = new BizOrderException();
    if(map.containsKey("biz_order_no")) {
      Object obj = map.get("biz_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_order_id")) {
      Object obj = map.get("biz_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBizOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBizOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBizOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("biz_order_type")) {
      Object obj = map.get("biz_order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_type")) {
      Object obj = map.get("exception_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_remark")) {
      Object obj = map.get("exception_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_submit_user_name")) {
      Object obj = map.get("exception_submit_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionSubmitUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_time")) {
      Object obj = map.get("exception_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExceptionTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExceptionTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExceptionTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExceptionTime(null);
      }
    }
    if(map.containsKey("exception_handle_user_name")) {
      Object obj = map.get("exception_handle_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionHandleUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_handle_time")) {
      Object obj = map.get("exception_handle_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExceptionHandleTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExceptionHandleTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExceptionHandleTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExceptionHandleTime(null);
      }
    }
    if(map.containsKey("exception_handle_remark")) {
      Object obj = map.get("exception_handle_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionHandleRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_handle_way")) {
      Object obj = map.get("exception_handle_way");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionHandleWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_type")) {
      Object obj = map.get("return_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("need_express")) {
      Object obj = map.get("need_express");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNeedExpress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handle_status")) {
      Object obj = map.get("handle_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("waybill_number")) {
      Object obj = map.get("waybill_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWaybillNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agent_email")) {
      Object obj = map.get("agent_email");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_express_number")) {
      Object obj = map.get("back_express_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackExpressNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_batch")) {
      Object obj = map.get("return_batch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnBatch((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("biz_order_no")) {
      Object obj = map.get("biz_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_order_id")) {
      Object obj = map.get("biz_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBizOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBizOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBizOrderId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("biz_order_type")) {
      Object obj = map.get("biz_order_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_type")) {
      Object obj = map.get("exception_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_remark")) {
      Object obj = map.get("exception_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_submit_user_name")) {
      Object obj = map.get("exception_submit_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionSubmitUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_time")) {
      Object obj = map.get("exception_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExceptionTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExceptionTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExceptionTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExceptionTime(null);
      }
    }
    if(map.containsKey("exception_handle_user_name")) {
      Object obj = map.get("exception_handle_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionHandleUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_handle_time")) {
      Object obj = map.get("exception_handle_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExceptionHandleTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExceptionHandleTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExceptionHandleTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExceptionHandleTime(null);
      }
    }
    if(map.containsKey("exception_handle_remark")) {
      Object obj = map.get("exception_handle_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionHandleRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_handle_way")) {
      Object obj = map.get("exception_handle_way");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionHandleWay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_type")) {
      Object obj = map.get("return_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("need_express")) {
      Object obj = map.get("need_express");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNeedExpress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handle_status")) {
      Object obj = map.get("handle_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandleStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("waybill_number")) {
      Object obj = map.get("waybill_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWaybillNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("agent_email")) {
      Object obj = map.get("agent_email");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAgentEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_express_number")) {
      Object obj = map.get("back_express_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBackExpressNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_batch")) {
      Object obj = map.get("return_batch");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnBatch((String)obj);
        }
      } else {
      }
    }
  }
}
