package com.xforceplus.purchaserordersaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 迁移使用
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class WkException implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 异常工单分类
   */
  @TableField("exceptionType")
  private String exceptionType;

  /**
   * 数据来源
   */
  @TableField("dataFromSystem")
  private String dataFromSystem;

  /**
   * 邮包快递单号
   */
  @TableField("packageCode")
  private String packageCode;

  /**
   * 结算单id
   */
  @TableField("orderId")
  private Long orderId;

  /**
   * 结算单编号
   */
  @TableField("orderCode")
  private String orderCode;

  /**
   * 发票id
   */
  @TableField("invoiceId")
  private Long invoiceId;

  /**
   * 发票代码
   */
  @TableField("billCode")
  private String billCode;

  /**
   * 发票号
   */
  @TableField("billNumber")
  private String billNumber;

  /**
   * 处理方式
   */
  @TableField("handleWay")
  private String handleWay;

  /**
   * 回寄快递单号
   */
  @TableField("backExpressNumber")
  private String backExpressNumber;

  /**
   * 异常处理备注
   */
  @TableField("exceptionNote")
  private String exceptionNote;

  /**
   * 处理人
   */
  @TableField("handlePerson")
  private String handlePerson;

  /**
   * 处理时间
   */
  @TableField("handleTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime handleTime;

  /**
   * 寄件人
   */
  @TableField("sendPerson")
  private String sendPerson;

  /**
   * 寄件人联系方式
   */
  @TableField("sendPersonPhone")
  private String sendPersonPhone;

  /**
   * 发起人
   */
  private String producter;

  /**
   * 发起时间
   */
  @TableField("productTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime productTime;

  /**
   * 处理状态
   */
  @TableField("handleStatus")
  private String handleStatus;

  /**
   * 异常工单处理说明
   */
  @TableField("handleRemark")
  private String handleRemark;

  /**
   * 异常原因分类
   */
  @TableField("errorType")
  private String errorType;

  /**
   * 是否实物签收
   */
  @TableField("confirmStatus")
  private String confirmStatus;

  /**
   * 暂挂时间
   */
  @TableField("holdTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime holdTime;

  /**
   * 确认人
   */
  private String creator;

  /**
   * 初审岗邮箱
   */
  @TableField("firstExamineEmail")
  private String firstExamineEmail;

  /**
   * 经办人邮箱
   */
  @TableField("agentEmail")
  private String agentEmail;

  /**
   * 收件人联系方式
   */
  @TableField("recipientPhone")
  private String recipientPhone;

  /**
   * 收件人
   */
  private String recipient;

  /**
   * 收件公司
   */
  @TableField("recipientCompany")
  private String recipientCompany;

  /**
   * 退回联次
   */
  @TableField("returnBatch")
  private String returnBatch;

  /**
   * 退回类型
   */
  @TableField("returnType")
  private String returnType;

  /**
   * 是否需要物流
   */
  @TableField("needExpress")
  private String needExpress;

  /**
   * 文件类型
   */
  @TableField("documentType")
  private String documentType;

  /**
   * 协同标识
   */
  @TableField("cooperateFlag")
  private String cooperateFlag;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("exceptionType", exceptionType);
      map.put("dataFromSystem", dataFromSystem);
      map.put("packageCode", packageCode);
      map.put("orderId", orderId);
      map.put("orderCode", orderCode);
      map.put("invoiceId", invoiceId);
      map.put("billCode", billCode);
      map.put("billNumber", billNumber);
      map.put("handleWay", handleWay);
      map.put("backExpressNumber", backExpressNumber);
      map.put("exceptionNote", exceptionNote);
      map.put("handlePerson", handlePerson);
      map.put("handleTime", BocpGenUtils.toTimestamp(handleTime));
      map.put("sendPerson", sendPerson);
      map.put("sendPersonPhone", sendPersonPhone);
      map.put("producter", producter);
      map.put("productTime", BocpGenUtils.toTimestamp(productTime));
      map.put("handleStatus", handleStatus);
      map.put("handleRemark", handleRemark);
      map.put("errorType", errorType);
      map.put("confirmStatus", confirmStatus);
      map.put("holdTime", BocpGenUtils.toTimestamp(holdTime));
      map.put("creator", creator);
      map.put("firstExamineEmail", firstExamineEmail);
      map.put("agentEmail", agentEmail);
      map.put("recipientPhone", recipientPhone);
      map.put("recipient", recipient);
      map.put("recipientCompany", recipientCompany);
      map.put("returnBatch", returnBatch);
      map.put("returnType", returnType);
      map.put("needExpress", needExpress);
      map.put("documentType", documentType);
      map.put("cooperateFlag", cooperateFlag);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static WkException fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    WkException entity = new WkException();
    if(map.containsKey("exceptionType")) {
      Object obj = map.get("exceptionType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataFromSystem")) {
      Object obj = map.get("dataFromSystem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataFromSystem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageCode")) {
      Object obj = map.get("packageCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderCode")) {
      Object obj = map.get("orderCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("billCode")) {
      Object obj = map.get("billCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billNumber")) {
      Object obj = map.get("billNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleWay")) {
      Object obj = map.get("handleWay");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandleWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("backExpressNumber")) {
      Object obj = map.get("backExpressNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackExpressNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exceptionNote")) {
      Object obj = map.get("exceptionNote");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionNote((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handlePerson")) {
      Object obj = map.get("handlePerson");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandlePerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleTime")) {
      Object obj = map.get("handleTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setHandleTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setHandleTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setHandleTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setHandleTime(null);
      }
    }
    if(map.containsKey("sendPerson")) {
      Object obj = map.get("sendPerson");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendPersonPhone")) {
      Object obj = map.get("sendPersonPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendPersonPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("producter")) {
      Object obj = map.get("producter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProducter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productTime")) {
      Object obj = map.get("productTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProductTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setProductTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProductTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setProductTime(null);
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleRemark")) {
      Object obj = map.get("handleRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandleRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorType")) {
      Object obj = map.get("errorType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("confirmStatus")) {
      Object obj = map.get("confirmStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConfirmStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("holdTime")) {
      Object obj = map.get("holdTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setHoldTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setHoldTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setHoldTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setHoldTime(null);
      }
    }
    if(map.containsKey("creator")) {
      Object obj = map.get("creator");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreator((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstExamineEmail")) {
      Object obj = map.get("firstExamineEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFirstExamineEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentEmail")) {
      Object obj = map.get("agentEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recipientPhone")) {
      Object obj = map.get("recipientPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecipientPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recipient")) {
      Object obj = map.get("recipient");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecipient((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recipientCompany")) {
      Object obj = map.get("recipientCompany");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecipientCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnBatch")) {
      Object obj = map.get("returnBatch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnType")) {
      Object obj = map.get("returnType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("needExpress")) {
      Object obj = map.get("needExpress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNeedExpress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cooperateFlag")) {
      Object obj = map.get("cooperateFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCooperateFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("exceptionType")) {
      Object obj = map.get("exceptionType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataFromSystem")) {
      Object obj = map.get("dataFromSystem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataFromSystem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("packageCode")) {
      Object obj = map.get("packageCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orderCode")) {
      Object obj = map.get("orderCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("billCode")) {
      Object obj = map.get("billCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billNumber")) {
      Object obj = map.get("billNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handleWay")) {
      Object obj = map.get("handleWay");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandleWay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("backExpressNumber")) {
      Object obj = map.get("backExpressNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBackExpressNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exceptionNote")) {
      Object obj = map.get("exceptionNote");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionNote((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handlePerson")) {
      Object obj = map.get("handlePerson");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandlePerson((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handleTime")) {
      Object obj = map.get("handleTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setHandleTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setHandleTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setHandleTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setHandleTime(null);
      }
    }
    if(map.containsKey("sendPerson")) {
      Object obj = map.get("sendPerson");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSendPerson((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sendPersonPhone")) {
      Object obj = map.get("sendPersonPhone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSendPersonPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("producter")) {
      Object obj = map.get("producter");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProducter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productTime")) {
      Object obj = map.get("productTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setProductTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setProductTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setProductTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setProductTime(null);
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandleStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handleRemark")) {
      Object obj = map.get("handleRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandleRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("errorType")) {
      Object obj = map.get("errorType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("confirmStatus")) {
      Object obj = map.get("confirmStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfirmStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("holdTime")) {
      Object obj = map.get("holdTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setHoldTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setHoldTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setHoldTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setHoldTime(null);
      }
    }
    if(map.containsKey("creator")) {
      Object obj = map.get("creator");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreator((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("firstExamineEmail")) {
      Object obj = map.get("firstExamineEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFirstExamineEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("agentEmail")) {
      Object obj = map.get("agentEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAgentEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recipientPhone")) {
      Object obj = map.get("recipientPhone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecipientPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recipient")) {
      Object obj = map.get("recipient");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecipient((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recipientCompany")) {
      Object obj = map.get("recipientCompany");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecipientCompany((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("returnBatch")) {
      Object obj = map.get("returnBatch");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnBatch((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("returnType")) {
      Object obj = map.get("returnType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("needExpress")) {
      Object obj = map.get("needExpress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNeedExpress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cooperateFlag")) {
      Object obj = map.get("cooperateFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCooperateFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
