package com.xforceplus.purchaserordersaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.ExceptionParcelPost;
import com.xforceplus.purchaserordersaas.service.IExceptionParcelPostService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 风险邮包对象前端控制器
 *
 * @author ultraman
 * @date 2023-07-12
 */
@RestController
public class ExceptionParcelPostController {

  @Autowired
  private IExceptionParcelPostService exceptionParcelPostServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param exceptionParcelPost 风险邮包对象
   * @return
   */
  @GetMapping("/exceptionparcelposts" )
  public XfR getExceptionParcelPosts(XfPage page, ExceptionParcelPost exceptionParcelPost) {
    return XfR.ok(exceptionParcelPostServiceImpl.page(page, Wrappers.query(exceptionParcelPost)));
  }

  /**
   * 通过id查询风险邮包对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/exceptionparcelposts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(exceptionParcelPostServiceImpl.getById(id));
  }

  /**
   * 新增风险邮包对象
   * @param exceptionParcelPost 风险邮包对象
   * @return XfR
   */
  @PostMapping("/exceptionparcelposts")
  public XfR save(@RequestBody ExceptionParcelPost exceptionParcelPost) {
     return XfR.ok(exceptionParcelPostServiceImpl.save(exceptionParcelPost));
  }

  /**
   * 修改-传入修改后的全部数据风险邮包对象
   * @param exceptionParcelPost 风险邮包对象
   * @return XfR
   */
  @PutMapping("/exceptionparcelposts/{id}")
  public XfR putUpdate(@RequestBody ExceptionParcelPost exceptionParcelPost,@PathVariable Long id) {
      exceptionParcelPost.setId(id);
      return XfR.ok(exceptionParcelPostServiceImpl.updateById(exceptionParcelPost));
  }

  /**
   * 修改-传入修改的数据风险邮包对象
   * @param exceptionParcelPost 风险邮包对象
   * @return XfR
   */
  @PatchMapping("/exceptionparcelposts/{id}")
  public XfR patchUpdate(@RequestBody ExceptionParcelPost exceptionParcelPost,@PathVariable Long id) {
      ExceptionParcelPost upexceptionParcelPost = exceptionParcelPostServiceImpl.getById(id);
      if(upexceptionParcelPost != null){
        upexceptionParcelPost = ObjectCopyUtils.copyProperties(exceptionParcelPost,upexceptionParcelPost,true);
      }
      return XfR.ok(exceptionParcelPostServiceImpl.updateById(upexceptionParcelPost));
  }

  /**
   * 通过id删除风险邮包对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/exceptionparcelposts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(exceptionParcelPostServiceImpl.removeById(id));
  }

  @PostMapping("/exceptionparcelposts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "exception_parcel_post");
     params.put("request", condition);

     return XfR.ok(exceptionParcelPostServiceImpl.querys(params));
  }

}
