package com.xforceplus.purchaserordersaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.ExceptionSalesBill;
import com.xforceplus.purchaserordersaas.service.IExceptionSalesBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 风险单据对象前端控制器
 *
 * @author ultraman
 * @date 2023-07-12
 */
@RestController
public class ExceptionSalesBillController {

  @Autowired
  private IExceptionSalesBillService exceptionSalesBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param exceptionSalesBill 风险单据对象
   * @return
   */
  @GetMapping("/exceptionsalesbills" )
  public XfR getExceptionSalesBills(XfPage page, ExceptionSalesBill exceptionSalesBill) {
    return XfR.ok(exceptionSalesBillServiceImpl.page(page, Wrappers.query(exceptionSalesBill)));
  }

  /**
   * 通过id查询风险单据对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/exceptionsalesbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(exceptionSalesBillServiceImpl.getById(id));
  }

  /**
   * 新增风险单据对象
   * @param exceptionSalesBill 风险单据对象
   * @return XfR
   */
  @PostMapping("/exceptionsalesbills")
  public XfR save(@RequestBody ExceptionSalesBill exceptionSalesBill) {
     return XfR.ok(exceptionSalesBillServiceImpl.save(exceptionSalesBill));
  }

  /**
   * 修改-传入修改后的全部数据风险单据对象
   * @param exceptionSalesBill 风险单据对象
   * @return XfR
   */
  @PutMapping("/exceptionsalesbills/{id}")
  public XfR putUpdate(@RequestBody ExceptionSalesBill exceptionSalesBill,@PathVariable Long id) {
      exceptionSalesBill.setId(id);
      return XfR.ok(exceptionSalesBillServiceImpl.updateById(exceptionSalesBill));
  }

  /**
   * 修改-传入修改的数据风险单据对象
   * @param exceptionSalesBill 风险单据对象
   * @return XfR
   */
  @PatchMapping("/exceptionsalesbills/{id}")
  public XfR patchUpdate(@RequestBody ExceptionSalesBill exceptionSalesBill,@PathVariable Long id) {
      ExceptionSalesBill upexceptionSalesBill = exceptionSalesBillServiceImpl.getById(id);
      if(upexceptionSalesBill != null){
        upexceptionSalesBill = ObjectCopyUtils.copyProperties(exceptionSalesBill,upexceptionSalesBill,true);
      }
      return XfR.ok(exceptionSalesBillServiceImpl.updateById(upexceptionSalesBill));
  }

  /**
   * 通过id删除风险单据对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/exceptionsalesbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(exceptionSalesBillServiceImpl.removeById(id));
  }

  @PostMapping("/exceptionsalesbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "exception_sales_bill");
     params.put("request", condition);

     return XfR.ok(exceptionSalesBillServiceImpl.querys(params));
  }

}
