package com.xforceplus.purchaserordersaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.ParcelPost;
import com.xforceplus.purchaserordersaas.service.IParcelPostService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 邮包对象前端控制器
 *
 * @author ultraman
 * @date 2023-07-12
 */
@RestController
public class ParcelPostController {

  @Autowired
  private IParcelPostService parcelPostServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param parcelPost 邮包对象
   * @return
   */
  @GetMapping("/parcelposts" )
  public XfR getParcelPosts(XfPage page, ParcelPost parcelPost) {
    return XfR.ok(parcelPostServiceImpl.page(page, Wrappers.query(parcelPost)));
  }

  /**
   * 通过id查询邮包对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/parcelposts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(parcelPostServiceImpl.getById(id));
  }

  /**
   * 新增邮包对象
   * @param parcelPost 邮包对象
   * @return XfR
   */
  @PostMapping("/parcelposts")
  public XfR save(@RequestBody ParcelPost parcelPost) {
     return XfR.ok(parcelPostServiceImpl.save(parcelPost));
  }

  /**
   * 修改-传入修改后的全部数据邮包对象
   * @param parcelPost 邮包对象
   * @return XfR
   */
  @PutMapping("/parcelposts/{id}")
  public XfR putUpdate(@RequestBody ParcelPost parcelPost,@PathVariable Long id) {
      parcelPost.setId(id);
      return XfR.ok(parcelPostServiceImpl.updateById(parcelPost));
  }

  /**
   * 修改-传入修改的数据邮包对象
   * @param parcelPost 邮包对象
   * @return XfR
   */
  @PatchMapping("/parcelposts/{id}")
  public XfR patchUpdate(@RequestBody ParcelPost parcelPost,@PathVariable Long id) {
      ParcelPost upparcelPost = parcelPostServiceImpl.getById(id);
      if(upparcelPost != null){
        upparcelPost = ObjectCopyUtils.copyProperties(parcelPost,upparcelPost,true);
      }
      return XfR.ok(parcelPostServiceImpl.updateById(upparcelPost));
  }

  /**
   * 通过id删除邮包对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/parcelposts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(parcelPostServiceImpl.removeById(id));
  }

  @PostMapping("/parcelposts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "parcel_post");
     params.put("request", condition);

     return XfR.ok(parcelPostServiceImpl.querys(params));
  }

}
