package com.xforceplus.purchaserordersaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.SalesBillInvoiceRelation;
import com.xforceplus.purchaserordersaas.service.ISalesBillInvoiceRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 业务单与发票的关系对象前端控制器
 *
 * @author ultraman
 * @date 2023-07-12
 */
@RestController
public class SalesBillInvoiceRelationController {

  @Autowired
  private ISalesBillInvoiceRelationService salesBillInvoiceRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesBillInvoiceRelation 业务单与发票的关系对象
   * @return
   */
  @GetMapping("/salesbillinvoicerelations" )
  public XfR getSalesBillInvoiceRelations(XfPage page, SalesBillInvoiceRelation salesBillInvoiceRelation) {
    return XfR.ok(salesBillInvoiceRelationServiceImpl.page(page, Wrappers.query(salesBillInvoiceRelation)));
  }

  /**
   * 通过id查询业务单与发票的关系对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesbillinvoicerelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesBillInvoiceRelationServiceImpl.getById(id));
  }

  /**
   * 新增业务单与发票的关系对象
   * @param salesBillInvoiceRelation 业务单与发票的关系对象
   * @return XfR
   */
  @PostMapping("/salesbillinvoicerelations")
  public XfR save(@RequestBody SalesBillInvoiceRelation salesBillInvoiceRelation) {
     return XfR.ok(salesBillInvoiceRelationServiceImpl.save(salesBillInvoiceRelation));
  }

  /**
   * 修改-传入修改后的全部数据业务单与发票的关系对象
   * @param salesBillInvoiceRelation 业务单与发票的关系对象
   * @return XfR
   */
  @PutMapping("/salesbillinvoicerelations/{id}")
  public XfR putUpdate(@RequestBody SalesBillInvoiceRelation salesBillInvoiceRelation,@PathVariable Long id) {
      salesBillInvoiceRelation.setId(id);
      return XfR.ok(salesBillInvoiceRelationServiceImpl.updateById(salesBillInvoiceRelation));
  }

  /**
   * 修改-传入修改的数据业务单与发票的关系对象
   * @param salesBillInvoiceRelation 业务单与发票的关系对象
   * @return XfR
   */
  @PatchMapping("/salesbillinvoicerelations/{id}")
  public XfR patchUpdate(@RequestBody SalesBillInvoiceRelation salesBillInvoiceRelation,@PathVariable Long id) {
      SalesBillInvoiceRelation upsalesBillInvoiceRelation = salesBillInvoiceRelationServiceImpl.getById(id);
      if(upsalesBillInvoiceRelation != null){
        upsalesBillInvoiceRelation = ObjectCopyUtils.copyProperties(salesBillInvoiceRelation,upsalesBillInvoiceRelation,true);
      }
      return XfR.ok(salesBillInvoiceRelationServiceImpl.updateById(upsalesBillInvoiceRelation));
  }

  /**
   * 通过id删除业务单与发票的关系对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesbillinvoicerelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesBillInvoiceRelationServiceImpl.removeById(id));
  }

  @PostMapping("/salesbillinvoicerelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_bill_invoice_relation");
     params.put("request", condition);

     return XfR.ok(salesBillInvoiceRelationServiceImpl.querys(params));
  }

}
