package com.xforceplus.purchaserordersaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.SalesBillItem;
import com.xforceplus.purchaserordersaas.service.ISalesBillItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 业务单明细对象前端控制器
 *
 * @author ultraman
 * @date 2023-07-12
 */
@RestController
public class SalesBillItemController {

  @Autowired
  private ISalesBillItemService salesBillItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesBillItem 业务单明细对象
   * @return
   */
  @GetMapping("/salesbillitems" )
  public XfR getSalesBillItems(XfPage page, SalesBillItem salesBillItem) {
    return XfR.ok(salesBillItemServiceImpl.page(page, Wrappers.query(salesBillItem)));
  }

  /**
   * 通过id查询业务单明细对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesbillitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesBillItemServiceImpl.getById(id));
  }

  /**
   * 新增业务单明细对象
   * @param salesBillItem 业务单明细对象
   * @return XfR
   */
  @PostMapping("/salesbillitems")
  public XfR save(@RequestBody SalesBillItem salesBillItem) {
     return XfR.ok(salesBillItemServiceImpl.save(salesBillItem));
  }

  /**
   * 修改-传入修改后的全部数据业务单明细对象
   * @param salesBillItem 业务单明细对象
   * @return XfR
   */
  @PutMapping("/salesbillitems/{id}")
  public XfR putUpdate(@RequestBody SalesBillItem salesBillItem,@PathVariable Long id) {
      salesBillItem.setId(id);
      return XfR.ok(salesBillItemServiceImpl.updateById(salesBillItem));
  }

  /**
   * 修改-传入修改的数据业务单明细对象
   * @param salesBillItem 业务单明细对象
   * @return XfR
   */
  @PatchMapping("/salesbillitems/{id}")
  public XfR patchUpdate(@RequestBody SalesBillItem salesBillItem,@PathVariable Long id) {
      SalesBillItem upsalesBillItem = salesBillItemServiceImpl.getById(id);
      if(upsalesBillItem != null){
        upsalesBillItem = ObjectCopyUtils.copyProperties(salesBillItem,upsalesBillItem,true);
      }
      return XfR.ok(salesBillItemServiceImpl.updateById(upsalesBillItem));
  }

  /**
   * 通过id删除业务单明细对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesbillitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesBillItemServiceImpl.removeById(id));
  }

  @PostMapping("/salesbillitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_bill_item");
     params.put("request", condition);

     return XfR.ok(salesBillItemServiceImpl.querys(params));
  }

}
