package com.xforceplus.purchaserordersaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.BizOrderException;
import com.xforceplus.purchaserordersaas.service.IBizOrderExceptionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 风险单据对象前端控制器
 *
 * @author ultraman
 * @date 2023-07-31
 */
@RestController
public class BizOrderExceptionController {

  @Autowired
  private IBizOrderExceptionService bizOrderExceptionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderException 风险单据对象
   * @return
   */
  @GetMapping("/bizorderexceptions" )
  public XfR getBizOrderExceptions(XfPage page, BizOrderException bizOrderException) {
    return XfR.ok(bizOrderExceptionServiceImpl.page(page, Wrappers.query(bizOrderException)));
  }

  /**
   * 通过id查询风险单据对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorderexceptions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderExceptionServiceImpl.getById(id));
  }

  /**
   * 新增风险单据对象
   * @param bizOrderException 风险单据对象
   * @return XfR
   */
  @PostMapping("/bizorderexceptions")
  public XfR save(@RequestBody BizOrderException bizOrderException) {
     return XfR.ok(bizOrderExceptionServiceImpl.save(bizOrderException));
  }

  /**
   * 修改-传入修改后的全部数据风险单据对象
   * @param bizOrderException 风险单据对象
   * @return XfR
   */
  @PutMapping("/bizorderexceptions/{id}")
  public XfR putUpdate(@RequestBody BizOrderException bizOrderException,@PathVariable Long id) {
      bizOrderException.setId(id);
      return XfR.ok(bizOrderExceptionServiceImpl.updateById(bizOrderException));
  }

  /**
   * 修改-传入修改的数据风险单据对象
   * @param bizOrderException 风险单据对象
   * @return XfR
   */
  @PatchMapping("/bizorderexceptions/{id}")
  public XfR patchUpdate(@RequestBody BizOrderException bizOrderException,@PathVariable Long id) {
      BizOrderException upbizOrderException = bizOrderExceptionServiceImpl.getById(id);
      if(upbizOrderException != null){
        upbizOrderException = ObjectCopyUtils.copyProperties(bizOrderException,upbizOrderException,true);
      }
      return XfR.ok(bizOrderExceptionServiceImpl.updateById(upbizOrderException));
  }

  /**
   * 通过id删除风险单据对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorderexceptions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderExceptionServiceImpl.removeById(id));
  }

  @PostMapping("/bizorderexceptions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_exception");
     params.put("request", condition);

     return XfR.ok(bizOrderExceptionServiceImpl.querys(params));
  }

}
