package com.xforceplus.purchaserordersaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.BizOrderItemSpecialInfo;
import com.xforceplus.purchaserordersaas.service.IBizOrderItemSpecialInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-31
 */
@RestController
public class BizOrderItemSpecialInfoController {

  @Autowired
  private IBizOrderItemSpecialInfoService bizOrderItemSpecialInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderItemSpecialInfo ${table.comment}
   * @return
   */
  @GetMapping("/bizorderitemspecialinfos" )
  public XfR getBizOrderItemSpecialInfos(XfPage page, BizOrderItemSpecialInfo bizOrderItemSpecialInfo) {
    return XfR.ok(bizOrderItemSpecialInfoServiceImpl.page(page, Wrappers.query(bizOrderItemSpecialInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorderitemspecialinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderItemSpecialInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bizOrderItemSpecialInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/bizorderitemspecialinfos")
  public XfR save(@RequestBody BizOrderItemSpecialInfo bizOrderItemSpecialInfo) {
     return XfR.ok(bizOrderItemSpecialInfoServiceImpl.save(bizOrderItemSpecialInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bizOrderItemSpecialInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/bizorderitemspecialinfos/{id}")
  public XfR putUpdate(@RequestBody BizOrderItemSpecialInfo bizOrderItemSpecialInfo,@PathVariable Long id) {
      bizOrderItemSpecialInfo.setId(id);
      return XfR.ok(bizOrderItemSpecialInfoServiceImpl.updateById(bizOrderItemSpecialInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bizOrderItemSpecialInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bizorderitemspecialinfos/{id}")
  public XfR patchUpdate(@RequestBody BizOrderItemSpecialInfo bizOrderItemSpecialInfo,@PathVariable Long id) {
      BizOrderItemSpecialInfo upbizOrderItemSpecialInfo = bizOrderItemSpecialInfoServiceImpl.getById(id);
      if(upbizOrderItemSpecialInfo != null){
        upbizOrderItemSpecialInfo = ObjectCopyUtils.copyProperties(bizOrderItemSpecialInfo,upbizOrderItemSpecialInfo,true);
      }
      return XfR.ok(bizOrderItemSpecialInfoServiceImpl.updateById(upbizOrderItemSpecialInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorderitemspecialinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderItemSpecialInfoServiceImpl.removeById(id));
  }

  @PostMapping("/bizorderitemspecialinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_item_special_info");
     params.put("request", condition);

     return XfR.ok(bizOrderItemSpecialInfoServiceImpl.querys(params));
  }

}
