package com.xforceplus.purchaserordersaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.BizOrderOperateLog;
import com.xforceplus.purchaserordersaas.service.IBizOrderOperateLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 业务单操作履历前端控制器
 *
 * @author ultraman
 * @date 2023-07-31
 */
@RestController
public class BizOrderOperateLogController {

  @Autowired
  private IBizOrderOperateLogService bizOrderOperateLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderOperateLog 业务单操作履历
   * @return
   */
  @GetMapping("/bizorderoperatelogs" )
  public XfR getBizOrderOperateLogs(XfPage page, BizOrderOperateLog bizOrderOperateLog) {
    return XfR.ok(bizOrderOperateLogServiceImpl.page(page, Wrappers.query(bizOrderOperateLog)));
  }

  /**
   * 通过id查询业务单操作履历
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorderoperatelogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderOperateLogServiceImpl.getById(id));
  }

  /**
   * 新增业务单操作履历
   * @param bizOrderOperateLog 业务单操作履历
   * @return XfR
   */
  @PostMapping("/bizorderoperatelogs")
  public XfR save(@RequestBody BizOrderOperateLog bizOrderOperateLog) {
     return XfR.ok(bizOrderOperateLogServiceImpl.save(bizOrderOperateLog));
  }

  /**
   * 修改-传入修改后的全部数据业务单操作履历
   * @param bizOrderOperateLog 业务单操作履历
   * @return XfR
   */
  @PutMapping("/bizorderoperatelogs/{id}")
  public XfR putUpdate(@RequestBody BizOrderOperateLog bizOrderOperateLog,@PathVariable Long id) {
      bizOrderOperateLog.setId(id);
      return XfR.ok(bizOrderOperateLogServiceImpl.updateById(bizOrderOperateLog));
  }

  /**
   * 修改-传入修改的数据业务单操作履历
   * @param bizOrderOperateLog 业务单操作履历
   * @return XfR
   */
  @PatchMapping("/bizorderoperatelogs/{id}")
  public XfR patchUpdate(@RequestBody BizOrderOperateLog bizOrderOperateLog,@PathVariable Long id) {
      BizOrderOperateLog upbizOrderOperateLog = bizOrderOperateLogServiceImpl.getById(id);
      if(upbizOrderOperateLog != null){
        upbizOrderOperateLog = ObjectCopyUtils.copyProperties(bizOrderOperateLog,upbizOrderOperateLog,true);
      }
      return XfR.ok(bizOrderOperateLogServiceImpl.updateById(upbizOrderOperateLog));
  }

  /**
   * 通过id删除业务单操作履历
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorderoperatelogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderOperateLogServiceImpl.removeById(id));
  }

  @PostMapping("/bizorderoperatelogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_operate_log");
     params.put("request", condition);

     return XfR.ok(bizOrderOperateLogServiceImpl.querys(params));
  }

}
