package com.xforceplus.purchaserordersaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.InvoiceView;
import com.xforceplus.purchaserordersaas.service.IInvoiceViewService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-31
 */
@RestController
public class InvoiceViewController {

  @Autowired
  private IInvoiceViewService invoiceViewServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceView ${table.comment}
   * @return
   */
  @GetMapping("/invoiceviews" )
  public XfR getInvoiceViews(XfPage page, InvoiceView invoiceView) {
    return XfR.ok(invoiceViewServiceImpl.page(page, Wrappers.query(invoiceView)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceviews/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceViewServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceView ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceviews")
  public XfR save(@RequestBody InvoiceView invoiceView) {
     return XfR.ok(invoiceViewServiceImpl.save(invoiceView));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceView ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceviews/{id}")
  public XfR putUpdate(@RequestBody InvoiceView invoiceView,@PathVariable Long id) {
      invoiceView.setId(id);
      return XfR.ok(invoiceViewServiceImpl.updateById(invoiceView));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceView ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceviews/{id}")
  public XfR patchUpdate(@RequestBody InvoiceView invoiceView,@PathVariable Long id) {
      InvoiceView upinvoiceView = invoiceViewServiceImpl.getById(id);
      if(upinvoiceView != null){
        upinvoiceView = ObjectCopyUtils.copyProperties(invoiceView,upinvoiceView,true);
      }
      return XfR.ok(invoiceViewServiceImpl.updateById(upinvoiceView));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceviews/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceViewServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceviews/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_view");
     params.put("request", condition);

     return XfR.ok(invoiceViewServiceImpl.querys(params));
  }

}
