package com.xforceplus.purchaserordersaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.BizOrderInvoiceRelation;
import com.xforceplus.purchaserordersaas.service.IBizOrderInvoiceRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 业务单与发票的关系对象前端控制器
 *
 * @author ultraman
 * @date 2023-07-20
 */
@RestController
public class BizOrderInvoiceRelationController {

  @Autowired
  private IBizOrderInvoiceRelationService bizOrderInvoiceRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderInvoiceRelation 业务单与发票的关系对象
   * @return
   */
  @GetMapping("/bizorderinvoicerelations" )
  public XfR getBizOrderInvoiceRelations(XfPage page, BizOrderInvoiceRelation bizOrderInvoiceRelation) {
    return XfR.ok(bizOrderInvoiceRelationServiceImpl.page(page, Wrappers.query(bizOrderInvoiceRelation)));
  }

  /**
   * 通过id查询业务单与发票的关系对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorderinvoicerelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderInvoiceRelationServiceImpl.getById(id));
  }

  /**
   * 新增业务单与发票的关系对象
   * @param bizOrderInvoiceRelation 业务单与发票的关系对象
   * @return XfR
   */
  @PostMapping("/bizorderinvoicerelations")
  public XfR save(@RequestBody BizOrderInvoiceRelation bizOrderInvoiceRelation) {
     return XfR.ok(bizOrderInvoiceRelationServiceImpl.save(bizOrderInvoiceRelation));
  }

  /**
   * 修改-传入修改后的全部数据业务单与发票的关系对象
   * @param bizOrderInvoiceRelation 业务单与发票的关系对象
   * @return XfR
   */
  @PutMapping("/bizorderinvoicerelations/{id}")
  public XfR putUpdate(@RequestBody BizOrderInvoiceRelation bizOrderInvoiceRelation,@PathVariable Long id) {
      bizOrderInvoiceRelation.setId(id);
      return XfR.ok(bizOrderInvoiceRelationServiceImpl.updateById(bizOrderInvoiceRelation));
  }

  /**
   * 修改-传入修改的数据业务单与发票的关系对象
   * @param bizOrderInvoiceRelation 业务单与发票的关系对象
   * @return XfR
   */
  @PatchMapping("/bizorderinvoicerelations/{id}")
  public XfR patchUpdate(@RequestBody BizOrderInvoiceRelation bizOrderInvoiceRelation,@PathVariable Long id) {
      BizOrderInvoiceRelation upbizOrderInvoiceRelation = bizOrderInvoiceRelationServiceImpl.getById(id);
      if(upbizOrderInvoiceRelation != null){
        upbizOrderInvoiceRelation = ObjectCopyUtils.copyProperties(bizOrderInvoiceRelation,upbizOrderInvoiceRelation,true);
      }
      return XfR.ok(bizOrderInvoiceRelationServiceImpl.updateById(upbizOrderInvoiceRelation));
  }

  /**
   * 通过id删除业务单与发票的关系对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorderinvoicerelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderInvoiceRelationServiceImpl.removeById(id));
  }

  @PostMapping("/bizorderinvoicerelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_invoice_relation");
     params.put("request", condition);

     return XfR.ok(bizOrderInvoiceRelationServiceImpl.querys(params));
  }

}
