package com.xforceplus.purchaserordersaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.ParcelPostException;
import com.xforceplus.purchaserordersaas.service.IParcelPostExceptionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 风险邮包对象前端控制器
 *
 * @author ultraman
 * @date 2023-07-20
 */
@RestController
public class ParcelPostExceptionController {

  @Autowired
  private IParcelPostExceptionService parcelPostExceptionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param parcelPostException 风险邮包对象
   * @return
   */
  @GetMapping("/parcelpostexceptions" )
  public XfR getParcelPostExceptions(XfPage page, ParcelPostException parcelPostException) {
    return XfR.ok(parcelPostExceptionServiceImpl.page(page, Wrappers.query(parcelPostException)));
  }

  /**
   * 通过id查询风险邮包对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/parcelpostexceptions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(parcelPostExceptionServiceImpl.getById(id));
  }

  /**
   * 新增风险邮包对象
   * @param parcelPostException 风险邮包对象
   * @return XfR
   */
  @PostMapping("/parcelpostexceptions")
  public XfR save(@RequestBody ParcelPostException parcelPostException) {
     return XfR.ok(parcelPostExceptionServiceImpl.save(parcelPostException));
  }

  /**
   * 修改-传入修改后的全部数据风险邮包对象
   * @param parcelPostException 风险邮包对象
   * @return XfR
   */
  @PutMapping("/parcelpostexceptions/{id}")
  public XfR putUpdate(@RequestBody ParcelPostException parcelPostException,@PathVariable Long id) {
      parcelPostException.setId(id);
      return XfR.ok(parcelPostExceptionServiceImpl.updateById(parcelPostException));
  }

  /**
   * 修改-传入修改的数据风险邮包对象
   * @param parcelPostException 风险邮包对象
   * @return XfR
   */
  @PatchMapping("/parcelpostexceptions/{id}")
  public XfR patchUpdate(@RequestBody ParcelPostException parcelPostException,@PathVariable Long id) {
      ParcelPostException upparcelPostException = parcelPostExceptionServiceImpl.getById(id);
      if(upparcelPostException != null){
        upparcelPostException = ObjectCopyUtils.copyProperties(parcelPostException,upparcelPostException,true);
      }
      return XfR.ok(parcelPostExceptionServiceImpl.updateById(upparcelPostException));
  }

  /**
   * 通过id删除风险邮包对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/parcelpostexceptions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(parcelPostExceptionServiceImpl.removeById(id));
  }

  @PostMapping("/parcelpostexceptions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "parcel_post_exception");
     params.put("request", condition);

     return XfR.ok(parcelPostExceptionServiceImpl.querys(params));
  }

}
