/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purconfig.app.config;

import com.xforceplus.xplatsecurity.Interceptor.AppApiSecurityInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;

@Configuration
public class AuthAppWebMvcConfiguration
implements WebMvcConfigurer {
    @Autowired
    AppApiSecurityInterceptor appApiSecurityInterceptor;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.appApiSecurityInterceptor).addPathPatterns(new String[]{"/api/v1/purconfig/**"});
        registry.addInterceptor((HandlerInterceptor)this.localeChangeInterceptor()).addPathPatterns(new String[]{"/api/v1/purconfig/**"});
    }

    @Bean
    public Validator getValidator() {
        LocalValidatorFactoryBean validator = new LocalValidatorFactoryBean();
        try {
            validator.setValidationMessageSource((MessageSource)this.getMessageSource());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return validator;
    }

    public ResourceBundleMessageSource getMessageSource() throws Exception {
        ResourceBundleMessageSource rbms = new ResourceBundleMessageSource();
        rbms.setDefaultEncoding("UTF-8");
        rbms.setBasenames(new String[]{"ValidationMessages"});
        rbms.setCacheSeconds(10);
        return rbms;
    }

    @Bean
    public LocaleChangeInterceptor localeChangeInterceptor() {
        LocaleChangeInterceptor lci = new LocaleChangeInterceptor();
        lci.setParamName("lang");
        return lci;
    }

    @Bean
    public LocaleResolver localeResolver() {
        CookieLocaleResolver cl = new CookieLocaleResolver();
        cl.setCookieName("lang");
        return cl;
    }
}

