/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purconfig.app.config;

import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Profile(value={"!prod"})
@Configuration
@EnableSwagger2
public class SpringFoxConfiguration {
    @Bean
    public Docket imscApiV1Docket() {
        return new Docket(DocumentationType.SWAGGER_2).securitySchemes(this.apiKeys()).securityContexts((List)Lists.newArrayList((Object[])new SecurityContext[]{this.securityContext()})).select().paths(PathSelectors.regex((String)".*")).paths(PathSelectors.regex((String)"/api/v1/purconfig/.*")).build().groupName("api-v1");
    }

    @Bean
    public Docket imscRestDocket() {
        return new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.withClassAnnotation(RestController.class)).paths(input -> !PathSelectors.regex((String)"/api/v1/.*").apply(input)).build().groupName("other");
    }

    private List<ApiKey> apiKeys() {
        return Lists.newArrayList((Object[])new ApiKey[]{new ApiKey("X-Access-Token", "X-Access-Token", "header")});
    }

    private SecurityContext securityContext() {
        return SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(path -> !PathSelectors.regex((String)"/security/.*").apply(path)).build();
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        return Lists.newArrayList((Object[])new SecurityReference[]{new SecurityReference("X-Access-Token", authorizationScopes)});
    }
}

