/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purconfig.app.service;

import com.google.common.collect.Lists;
import com.xforceplus.purchaser.common.utils.CommonUtils;
import com.xforceplus.purchaser.common.utils.JsonUtils;
import com.xforceplus.purconfig.app.client.AuthBlockClient;
import com.xforceplus.purconfig.app.client.OrgClient;
import com.xforceplus.purconfig.app.model.BlockTabResponse;
import com.xforceplus.purconfig.app.model.CreateAuthBlockRequest;
import com.xforceplus.purconfig.app.model.DeleteAuthBlockRequest;
import com.xforceplus.purconfig.app.model.GeneralResponse;
import com.xforceplus.purconfig.app.model.ListAuthBlockRequest;
import com.xforceplus.purconfig.app.model.ListAuthBlockResponse;
import com.xforceplus.purconfig.app.model.UpdateAuthBlockRequest;
import com.xforceplus.purconfig.app.service.AuthBlockAppService;
import com.xforceplus.purconfig.app.service.BeanUtils;
import com.xforceplus.purconfig.client.model.MsBlockTabResponse;
import com.xforceplus.purconfig.client.model.MsCreateAuthBlockRequest;
import com.xforceplus.purconfig.client.model.MsDeleteAuthBlockRequest;
import com.xforceplus.purconfig.client.model.MsGeneralResponse;
import com.xforceplus.purconfig.client.model.MsListAuthBlockRequest;
import com.xforceplus.purconfig.client.model.MsListAuthBlockResponse;
import com.xforceplus.purconfig.client.model.MsUpdateAuthBlockRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgListRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgListResponse;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatframework.enums.ErrorCodeEnum;
import com.xforceplus.xplatframework.exception.ResultCode;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthBlockAppServiceImpl
implements AuthBlockAppService {
    private static final Logger log = LoggerFactory.getLogger(AuthBlockAppServiceImpl.class);
    @Autowired
    private AuthBlockClient authBlockClient;
    @Autowired
    private OrgClient orgClient;

    public GeneralResponse createAuthBlock(CreateAuthBlockRequest request, UserSessionInfo userSessionInfo) {
        GeneralResponse response = new GeneralResponse();
        if (CommonUtils.isEmpty((List)request.getCompanys())) {
            response.setCode(ResultCode.PARAM_IS_BLANK.getCode());
            response.setMessage("\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a");
            return response;
        }
        if (CommonUtils.isEmpty((String)request.getOverWrite())) {
            request.setOverWrite("false");
        }
        MsCreateAuthBlockRequest msCreateAuthBlockRequest = new MsCreateAuthBlockRequest();
        BeanUtils.copyProperties((Object)request, (Object)msCreateAuthBlockRequest);
        msCreateAuthBlockRequest.setCreateUserId(Long.valueOf(userSessionInfo.getSysUserId()));
        msCreateAuthBlockRequest.setCreateUserName(userSessionInfo.getSysUserName());
        msCreateAuthBlockRequest.setGroupId(Long.valueOf(userSessionInfo.getGroupId()));
        msCreateAuthBlockRequest.setGroupName(userSessionInfo.getGroupName());
        log.info("begin service createAuthBlock:" + msCreateAuthBlockRequest.toString());
        MsGeneralResponse msGeneralResponse = this.authBlockClient.createAuthBlock(msCreateAuthBlockRequest);
        log.info("end createAuthBlock");
        BeanUtils.copyProperties((Object)msGeneralResponse, (Object)response);
        return response;
    }

    public GeneralResponse deleteAuthBlock(DeleteAuthBlockRequest request, UserSessionInfo userSessionInfo) {
        GeneralResponse response = new GeneralResponse();
        if (CommonUtils.isEmpty((List)request.getIds())) {
            response.setCode(ResultCode.PARAM_IS_BLANK.getCode());
            response.setMessage("\u4e3b\u952e\u4e3a\u7a7a");
            return response;
        }
        MsDeleteAuthBlockRequest msDeleteAuthBlockRequest = new MsDeleteAuthBlockRequest();
        BeanUtils.copyProperties((Object)request, (Object)msDeleteAuthBlockRequest);
        msDeleteAuthBlockRequest.setUpdateId(Long.valueOf(userSessionInfo.getSysUserId()));
        msDeleteAuthBlockRequest.setUpdateName(userSessionInfo.getSysUserName());
        log.info("begin service deleteAuthBlock:" + msDeleteAuthBlockRequest.toString());
        MsGeneralResponse msGeneralResponse = this.authBlockClient.deleteAuthBlock(msDeleteAuthBlockRequest);
        log.info("end deleteAuthBlock");
        BeanUtils.copyProperties((Object)msGeneralResponse, (Object)response);
        return response;
    }

    public ListAuthBlockResponse listAuthBlock(ListAuthBlockRequest request, UserSessionInfo userSessionInfo) {
        ListAuthBlockResponse response = new ListAuthBlockResponse();
        if (request.getPageIndex() <= 0) {
            request.setPageIndex(Integer.valueOf(0));
        } else {
            request.setPageIndex(Integer.valueOf(request.getPageIndex() - 1));
        }
        if (request.getPageSize() <= 0) {
            request.setPageSize(Integer.valueOf(20));
        }
        if (request.getStatus() != 1 && request.getStatus() != 2) {
            response.setCode(ResultCode.PARAM_IS_INVALID.getCode());
            response.setMessage("\u6570\u636e\u72b6\u6001\u4e0d\u6b63\u786e");
            return response;
        }
        List orgModelList = this.getOrgInfoList(Long.valueOf(userSessionInfo.getGroupId()), Long.valueOf(userSessionInfo.getSysUserId()), Integer.valueOf(1));
        List orgIds = orgModelList.stream().map(r -> r.getOrgStructId()).collect(Collectors.toList());
        MsListAuthBlockRequest msListAuthBlockRequest = new MsListAuthBlockRequest();
        BeanUtils.copyProperties((Object)request, (Object)msListAuthBlockRequest);
        msListAuthBlockRequest.setGroupId(Long.valueOf(userSessionInfo.getGroupId()));
        msListAuthBlockRequest.setOrgIds(orgIds);
        log.info("begin service listAuthBlock:" + msListAuthBlockRequest.toString());
        MsListAuthBlockResponse msListAuthBlockResponse = this.authBlockClient.listAuthBlock(msListAuthBlockRequest);
        log.info("end listAuthBlock");
        BeanUtils.copyProperties((Object)msListAuthBlockResponse, (Object)response);
        return response;
    }

    public GeneralResponse updateAuthBlock(UpdateAuthBlockRequest request, UserSessionInfo userSessionInfo) {
        GeneralResponse response = new GeneralResponse();
        if (CommonUtils.isEmpty((List)request.getIds())) {
            response.setCode(ResultCode.PARAM_IS_BLANK.getCode());
            response.setMessage("\u4e3b\u952e\u4e3a\u7a7a");
            return response;
        }
        if (null == request.getStatus() || 0 == request.getStatus()) {
            response.setCode(ResultCode.PARAM_IS_BLANK.getCode());
            response.setMessage("\u5f53\u524d\u5c01\u9501\u72b6\u6001\u4e3a\u7a7a");
            return response;
        }
        MsUpdateAuthBlockRequest msUpdateAuthBlockRequest = new MsUpdateAuthBlockRequest();
        BeanUtils.copyProperties((Object)request, (Object)msUpdateAuthBlockRequest);
        msUpdateAuthBlockRequest.setUpdateUserId(Long.valueOf(userSessionInfo.getSysUserId()));
        msUpdateAuthBlockRequest.setUpdateUserName(userSessionInfo.getSysUserName());
        log.info("begin service updateAuthBlock:" + msUpdateAuthBlockRequest.toString());
        MsGeneralResponse msGeneralResponse = this.authBlockClient.updateAuthBlock(msUpdateAuthBlockRequest);
        log.info("end updateAuthBlock");
        BeanUtils.copyProperties((Object)msGeneralResponse, (Object)response);
        return response;
    }

    public BlockTabResponse blockTab(ListAuthBlockRequest request, UserSessionInfo userSessionInfo) {
        BlockTabResponse response = new BlockTabResponse();
        MsListAuthBlockRequest msListAuthBlockRequest = new MsListAuthBlockRequest();
        BeanUtils.copyProperties((Object)request, (Object)msListAuthBlockRequest);
        log.info("blockTab\u5f00\u59cb\u8c03\u7528\u7ec4\u7ec7id");
        List orgModelList = this.getOrgInfoList(Long.valueOf(userSessionInfo.getGroupId()), Long.valueOf(userSessionInfo.getSysUserId()), Integer.valueOf(1));
        List orgIds = orgModelList.stream().map(r -> r.getOrgStructId()).collect(Collectors.toList());
        log.info("blockTab\u7ed3\u675f\u8c03\u7528\u7ec4\u7ec7id");
        msListAuthBlockRequest.setGroupId(Long.valueOf(userSessionInfo.getGroupId()));
        msListAuthBlockRequest.setOrgIds(orgIds);
        MsBlockTabResponse msBlockTabResponse = this.authBlockClient.blockTab(msListAuthBlockRequest);
        BeanUtils.copyProperties((Object)msBlockTabResponse, (Object)response);
        return response;
    }

    public List<OrgModel> getOrgInfoList(Long groupId, Long sysUserId, Integer orgType) {
        List orgList = Lists.newArrayList();
        GetOrgListRequest clientRequest = new GetOrgListRequest();
        clientRequest.setAppid("phoenix-auth-app");
        clientRequest.setRid(sysUserId.toString());
        clientRequest.setGroupID(groupId);
        if (orgType != null) {
            clientRequest.setSingleOrgType(orgType);
        }
        if (sysUserId != null) {
            clientRequest.setUserID(sysUserId);
        }
        clientRequest.setPage(Integer.valueOf(0));
        clientRequest.setRow(Integer.valueOf(1000));
        log.info("getOrgIdList: input param: {}", (Object)JsonUtils.writeObjectToJson((Object)clientRequest));
        GetOrgListResponse clientResponse = this.orgClient.getOrgList(clientRequest);
        log.info("getOrgIdList: return value: " + JsonUtils.writeObjectToJson((Object)clientResponse));
        if (clientResponse.getCode().intValue() == ErrorCodeEnum.SUCCESS.code() && clientResponse.getResult() != null) {
            if (clientResponse.getTotal() > 1000L) {
                clientRequest.setRow(Integer.valueOf(clientResponse.getTotal().intValue()));
                clientResponse = this.orgClient.getOrgList(clientRequest);
            }
            orgList = clientResponse.getResult();
        }
        return orgList;
    }
}

