/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purconfig.app.service;

import com.google.common.collect.Lists;
import com.xforceplus.purchaser.common.utils.CommonUtils;
import com.xforceplus.purchaser.common.utils.JsonUtils;
import com.xforceplus.purconfig.app.client.AuthQuotaClient;
import com.xforceplus.purconfig.app.client.OrgClient;
import com.xforceplus.purconfig.app.model.CreateAuthQuotaRequest;
import com.xforceplus.purconfig.app.model.DeleteAuthQuotaRequest;
import com.xforceplus.purconfig.app.model.GeneralResponse;
import com.xforceplus.purconfig.app.model.ListAuthQuotaRequest;
import com.xforceplus.purconfig.app.model.ListAuthQuotaResponse;
import com.xforceplus.purconfig.app.model.QuotaTabResponse;
import com.xforceplus.purconfig.app.model.UpdateAuthQuotaRequest;
import com.xforceplus.purconfig.app.service.AuthQuotaAppSerivce;
import com.xforceplus.purconfig.app.service.BeanUtils;
import com.xforceplus.purconfig.client.model.MsCreateAuthQuotaRequest;
import com.xforceplus.purconfig.client.model.MsDeleteAuthQuotaRequest;
import com.xforceplus.purconfig.client.model.MsGeneralResponse;
import com.xforceplus.purconfig.client.model.MsListAuthQuotaRequest;
import com.xforceplus.purconfig.client.model.MsListAuthQuotaResponse;
import com.xforceplus.purconfig.client.model.MsQuotaTabResponse;
import com.xforceplus.purconfig.client.model.MsUpdateAuthQuotaRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgListRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgListResponse;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatframework.enums.ErrorCodeEnum;
import com.xforceplus.xplatframework.exception.ResultCode;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthQuotaAppServiceImpl
implements AuthQuotaAppSerivce {
    private static final Logger log = LoggerFactory.getLogger(AuthQuotaAppServiceImpl.class);
    @Autowired
    private AuthQuotaClient authQuotaClient;
    @Autowired
    private OrgClient orgClient;

    public GeneralResponse createAuthQuota(CreateAuthQuotaRequest request, UserSessionInfo userSessionInfo) {
        GeneralResponse response = new GeneralResponse();
        if (CommonUtils.isEmpty((List)request.getCompanys())) {
            response.setCode(ResultCode.PARAM_IS_BLANK.getCode());
            response.setMessage("\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a");
            return response;
        }
        if (CommonUtils.isEmpty((List)request.getQuotaMonths())) {
            response.setCode(ResultCode.PARAM_IS_BLANK.getCode());
            response.setMessage("\u9650\u989d\u6708\u4efd\u4e3a\u7a7a");
            return response;
        }
        if (CommonUtils.isEmpty((String)request.getQuota())) {
            response.setCode(ResultCode.PARAM_IS_BLANK.getCode());
            response.setMessage("\u9650\u989d\u4e3a\u7a7a");
            return response;
        }
        if (new BigDecimal(request.getQuota()).compareTo(BigDecimal.ZERO) <= 0) {
            response.setCode(ResultCode.PARAM_IS_INVALID.getCode());
            response.setMessage("\u9650\u989d\u5fc5\u987b\u5927\u4e8e0");
            return response;
        }
        if (CommonUtils.isEmpty((String)request.getOverWrite())) {
            request.setOverWrite("false");
        }
        MsCreateAuthQuotaRequest msCreateAuthQuotaRequest = new MsCreateAuthQuotaRequest();
        BeanUtils.copyProperties((Object)request, (Object)msCreateAuthQuotaRequest);
        msCreateAuthQuotaRequest.setGroupName(userSessionInfo.getGroupName());
        msCreateAuthQuotaRequest.setCreateName(userSessionInfo.getSysUserName());
        msCreateAuthQuotaRequest.setCreateId(Long.valueOf(userSessionInfo.getSysUserId()));
        msCreateAuthQuotaRequest.setGroupId(Long.valueOf(userSessionInfo.getGroupId()));
        log.info("begin service createAuthQuota:" + msCreateAuthQuotaRequest.toString());
        MsGeneralResponse msGeneralResponse = this.authQuotaClient.createAuthQuota(msCreateAuthQuotaRequest);
        log.info("end createAuthQuota");
        BeanUtils.copyProperties((Object)msGeneralResponse, (Object)response);
        return response;
    }

    public GeneralResponse deleteAuthQuota(DeleteAuthQuotaRequest request, UserSessionInfo userSessionInfo) {
        GeneralResponse response = new GeneralResponse();
        if (CommonUtils.isEmpty((List)request.getIds())) {
            response.setCode(ResultCode.PARAM_IS_BLANK.getCode());
            response.setMessage("\u53c2\u6570ids\u4e3a\u7a7a");
            return response;
        }
        MsDeleteAuthQuotaRequest msDeleteAuthQuotaRequest = new MsDeleteAuthQuotaRequest();
        BeanUtils.copyProperties((Object)request, (Object)msDeleteAuthQuotaRequest);
        msDeleteAuthQuotaRequest.setUpdateId(Long.valueOf(userSessionInfo.getSysUserId()));
        msDeleteAuthQuotaRequest.setUpdateName(userSessionInfo.getSysUserName());
        log.info("begin service deleteAuthQuota:" + msDeleteAuthQuotaRequest.toString());
        MsGeneralResponse msGeneralResponse = this.authQuotaClient.deleteAuthQuota(msDeleteAuthQuotaRequest);
        log.info("end deleteAuthQuota");
        BeanUtils.copyProperties((Object)msGeneralResponse, (Object)response);
        return response;
    }

    public ListAuthQuotaResponse listAuthQuota(ListAuthQuotaRequest request, UserSessionInfo userSessionInfo) {
        ListAuthQuotaResponse response = new ListAuthQuotaResponse();
        if (request.getPageIndex() <= 0) {
            request.setPageIndex(Integer.valueOf(0));
        } else {
            request.setPageIndex(Integer.valueOf(request.getPageIndex() - 1));
        }
        if (request.getPageSize() <= 0) {
            request.setPageSize(Integer.valueOf(20));
        }
        if (request.getStatus() != 1 && request.getStatus() != 2) {
            response.setCode(ResultCode.PARAM_IS_INVALID.getCode());
            response.setMessage("\u6570\u636e\u72b6\u6001\u4e0d\u6b63\u786e");
            return response;
        }
        List orgModelList = this.getOrgInfoList(Long.valueOf(userSessionInfo.getGroupId()), Long.valueOf(userSessionInfo.getSysUserId()), Integer.valueOf(1));
        List orgIds = orgModelList.stream().map(r -> r.getOrgStructId()).collect(Collectors.toList());
        MsListAuthQuotaRequest msListAuthQuotaRequest = new MsListAuthQuotaRequest();
        BeanUtils.copyProperties((Object)request, (Object)msListAuthQuotaRequest);
        msListAuthQuotaRequest.setGroupId(Long.valueOf(userSessionInfo.getGroupId()));
        msListAuthQuotaRequest.setOrgIds(orgIds);
        log.info("begin service listAuthQuota:" + msListAuthQuotaRequest.toString());
        MsListAuthQuotaResponse msListAuthQuotaResponse = this.authQuotaClient.listAuthQuota(msListAuthQuotaRequest);
        log.info("end listAuthQuota");
        BeanUtils.copyProperties((Object)msListAuthQuotaResponse, (Object)response);
        return response;
    }

    public QuotaTabResponse quotaTab(ListAuthQuotaRequest request, UserSessionInfo userSessionInfo) {
        QuotaTabResponse response = new QuotaTabResponse();
        MsListAuthQuotaRequest msListAuthQuotaRequest = new MsListAuthQuotaRequest();
        BeanUtils.copyProperties((Object)request, (Object)msListAuthQuotaRequest);
        List orgModelList = this.getOrgInfoList(Long.valueOf(userSessionInfo.getGroupId()), Long.valueOf(userSessionInfo.getSysUserId()), Integer.valueOf(1));
        List orgIds = orgModelList.stream().map(r -> r.getOrgStructId()).collect(Collectors.toList());
        msListAuthQuotaRequest.setGroupId(Long.valueOf(userSessionInfo.getGroupId()));
        msListAuthQuotaRequest.setOrgIds(orgIds);
        MsQuotaTabResponse msListAuthQuotaResponse = this.authQuotaClient.quotaTab(msListAuthQuotaRequest);
        BeanUtils.copyProperties((Object)msListAuthQuotaResponse, (Object)response);
        return response;
    }

    public GeneralResponse updateAuthQuota(UpdateAuthQuotaRequest request, UserSessionInfo userSessionInfo) {
        GeneralResponse response = new GeneralResponse();
        if (null == request.getId() || null == request.getQuota()) {
            response.setCode(ResultCode.PARAM_IS_BLANK.getCode());
            response.setMessage("\u53c2\u6570id/\u9650\u989d\u4e3a\u7a7a");
            return response;
        }
        MsUpdateAuthQuotaRequest msUpdateAuthQuotaRequest = new MsUpdateAuthQuotaRequest();
        BeanUtils.copyProperties((Object)request, (Object)msUpdateAuthQuotaRequest);
        msUpdateAuthQuotaRequest.setUpdateId(Long.valueOf(userSessionInfo.getSysUserId()));
        msUpdateAuthQuotaRequest.setUpdateName(userSessionInfo.getSysUserName());
        log.info("begin service updateAuthQuota:" + msUpdateAuthQuotaRequest.toString());
        MsGeneralResponse msGeneralResponse = this.authQuotaClient.updateAuthQuota(msUpdateAuthQuotaRequest);
        log.info("end updateAuthQuota");
        BeanUtils.copyProperties((Object)msGeneralResponse, (Object)response);
        return response;
    }

    public List<OrgModel> getOrgInfoList(Long groupId, Long sysUserId, Integer orgType) {
        List orgList = Lists.newArrayList();
        GetOrgListRequest clientRequest = new GetOrgListRequest();
        clientRequest.setAppid("phoenix-auth-app");
        clientRequest.setRid(sysUserId.toString());
        clientRequest.setGroupID(groupId);
        if (orgType != null) {
            clientRequest.setSingleOrgType(orgType);
        }
        if (sysUserId != null) {
            clientRequest.setUserID(sysUserId);
        }
        clientRequest.setPage(Integer.valueOf(0));
        clientRequest.setRow(Integer.valueOf(1000));
        log.info("getOrgIdList: input param: {}", (Object)JsonUtils.writeObjectToJson((Object)clientRequest));
        GetOrgListResponse clientResponse = this.orgClient.getOrgList(clientRequest);
        log.info("getOrgIdList: return value: " + JsonUtils.writeObjectToJson((Object)clientResponse));
        if (clientResponse.getCode().intValue() == ErrorCodeEnum.SUCCESS.code() && clientResponse.getResult() != null) {
            if (clientResponse.getTotal() > 1000L) {
                clientRequest.setRow(Integer.valueOf(clientResponse.getTotal().intValue()));
                clientResponse = this.orgClient.getOrgList(clientRequest);
            }
            orgList = clientResponse.getResult();
        }
        return orgList;
    }
}

