/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purconfig.app.service;

import com.xforceplus.purconfig.app.client.ConfigItemClient;
import com.xforceplus.purconfig.app.model.GetConfigItemRequest;
import com.xforceplus.purconfig.app.model.GetConfigItemResponse;
import com.xforceplus.purconfig.app.service.BeanUtils;
import com.xforceplus.purconfig.app.service.ConfigItemService;
import com.xforceplus.purconfig.client.model.config.ConfigItemCodeEnum;
import com.xforceplus.purconfig.client.model.config.ConfigItemRequest;
import com.xforceplus.purconfig.client.model.config.ConfigItemResponse;
import com.xforceplus.xplatframework.exception.ResultCode;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ConfigItemServiceImpl
implements ConfigItemService {
    private static final Logger log = LoggerFactory.getLogger(ConfigItemServiceImpl.class);
    @Autowired
    ConfigItemClient configItemClient;

    public GetConfigItemResponse getConfigItem(GetConfigItemRequest request, UserSessionInfo userSessionInfo) {
        GetConfigItemResponse response = new GetConfigItemResponse();
        log.info("##### getConfigItem request : {}", (Object)request);
        if (StringUtils.isEmpty((Object)request.getConfigItemCode())) {
            response.setCode(ResultCode.PARAM_IS_BLANK.code());
            response.setMessage(ResultCode.PARAM_IS_BLANK.message());
            return response;
        }
        ConfigItemRequest msRequest = new ConfigItemRequest();
        ConfigItemCodeEnum configItemCodeEnum = null;
        try {
            configItemCodeEnum = ConfigItemCodeEnum.valueOf((String)request.getConfigItemCode());
        }
        catch (Exception e) {
            response.setCode(ResultCode.PARAM_IS_INVALID.code());
            response.setMessage(ResultCode.PARAM_IS_INVALID.message());
            return response;
        }
        msRequest.setConfigItemCode(configItemCodeEnum);
        msRequest.setGroupId(Long.valueOf(userSessionInfo.getGroupId()));
        ConfigItemResponse msResponse = this.configItemClient.getConfigItem(msRequest);
        BeanUtils.copyProperties((Object)msResponse, (Object)response);
        log.info("##### getConfigItem response : {}", (Object)response);
        return response;
    }
}

