/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purconfig.app.service;

import com.google.common.collect.Lists;
import com.xforceplus.bss.external.client.model.SearchCompanyListRequest;
import com.xforceplus.bss.external.client.model.SearchCompanyListResponse;
import com.xforceplus.phoenix.casm.model.MsListCasRequest;
import com.xforceplus.phoenix.casm.model.MsListCasResult;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.purchaser.common.utils.CommonUtils;
import com.xforceplus.purchaser.common.utils.JsonUtils;
import com.xforceplus.purconfig.app.client.CasmIndexClient;
import com.xforceplus.purconfig.app.client.CompanyClient;
import com.xforceplus.purconfig.app.client.FilterClient;
import com.xforceplus.purconfig.app.client.OrgClient;
import com.xforceplus.purconfig.app.model.DownloadTemplateModel;
import com.xforceplus.purconfig.app.model.FilterConditionInfoRequest;
import com.xforceplus.purconfig.app.model.FilterGroup;
import com.xforceplus.purconfig.app.model.FilterGroupInfoRequest;
import com.xforceplus.purconfig.app.model.FilterGroupResponse;
import com.xforceplus.purconfig.app.model.FilterTemplateResponse;
import com.xforceplus.purconfig.app.model.GeneralResponse;
import com.xforceplus.purconfig.app.model.ImportFileInfo;
import com.xforceplus.purconfig.app.model.ImportInvoiceDataRequest;
import com.xforceplus.purconfig.app.model.InvoiceFilter;
import com.xforceplus.purconfig.app.model.InvoiceFilterObj;
import com.xforceplus.purconfig.app.model.InvoiceFilterResponse;
import com.xforceplus.purconfig.app.model.InvoiceInfoObj;
import com.xforceplus.purconfig.app.model.InvoiceInfoResponse;
import com.xforceplus.purconfig.app.model.InvoiceObj;
import com.xforceplus.purconfig.app.model.SearchCompanyRequest;
import com.xforceplus.purconfig.app.service.FilterAppService;
import com.xforceplus.purconfig.app.utils.PurconfigConstant;
import com.xforceplus.purconfig.client.model.MsFilterConditionInfoRequest;
import com.xforceplus.purconfig.client.model.MsFilterGroupInfoRequest;
import com.xforceplus.purconfig.client.model.MsFilterGroupRequest;
import com.xforceplus.purconfig.client.model.MsFilterGroupResponse;
import com.xforceplus.purconfig.client.model.MsFilterTemplateResponse;
import com.xforceplus.purconfig.client.model.MsGeneralResponse;
import com.xforceplus.purconfig.client.model.MsImportInvoiceRequest;
import com.xforceplus.purconfig.client.model.MsInvoiceFilter;
import com.xforceplus.purconfig.client.model.MsInvoiceFilterObj;
import com.xforceplus.purconfig.client.model.MsInvoiceFilterResponse;
import com.xforceplus.purconfig.client.model.MsInvoiceInfoObj;
import com.xforceplus.purconfig.client.model.MsInvoiceInfoResponse;
import com.xforceplus.ucenter.external.client.model.GetOrgListRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgListResponse;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilterAppServiceImpl
implements FilterAppService {
    private static final Logger logger = LoggerFactory.getLogger(FilterAppServiceImpl.class);
    @Autowired
    private FilterClient filterClient;
    @Autowired
    private CompanyClient companyClient;
    @Autowired
    private CasmIndexClient casmIndexClient;
    @Autowired
    private OrgClient orgClient;

    public InvoiceFilterResponse getFilterDatas(Integer resourceType) {
        InvoiceFilterResponse response = new InvoiceFilterResponse();
        logger.info("getFilterDatas: input param: " + resourceType);
        MsInvoiceFilterResponse clientResponse = this.filterClient.getFilterDatas(resourceType);
        logger.info("getFilterDatas: return value: code:{},message:{}", (Object)clientResponse.getCode(), (Object)clientResponse.getMessage());
        response.setCode(clientResponse.getCode());
        response.setMessage(clientResponse.getMessage());
        InvoiceFilterObj filterObj = new InvoiceFilterObj();
        if (clientResponse.getResult() != null) {
            MsInvoiceFilterObj msFilterObj = clientResponse.getResult();
            List<Object> invoiceFilters = Lists.newArrayList();
            if (msFilterObj.getTitleList() != null) {
                invoiceFilters = msFilterObj.getTitleList().stream().map(r -> this.toInvoiceFilter(r)).collect(Collectors.toList());
            }
            filterObj.setTitleList((List)invoiceFilters);
            filterObj.setDataList(msFilterObj.getDataList());
        }
        response.setResult(filterObj);
        return response;
    }

    public FilterGroupResponse getCheckedFilterGroups(Integer resourceType, UserSessionInfo userSessionInfo) {
        FilterGroupResponse response = new FilterGroupResponse();
        MsFilterGroupRequest clientRequest = new MsFilterGroupRequest();
        clientRequest.setResourceType(resourceType);
        clientRequest.setUserId(Long.valueOf(userSessionInfo.getSysUserId()));
        clientRequest.setUserName(userSessionInfo.getSysUserName());
        logger.info("getCheckedFilterGroups: input param: " + clientRequest.toString());
        MsFilterGroupResponse clientResponse = this.filterClient.getCheckedFilterGroups(clientRequest);
        logger.info("getCheckedFilterGroups: return value: code:{},message:{}", (Object)clientResponse.getCode(), (Object)clientResponse.getMessage());
        response.setCode(clientResponse.getCode());
        response.setMessage(clientResponse.getMessage());
        List<Object> filterGroups = Lists.newArrayList();
        if (clientResponse.getResult() != null) {
            filterGroups = clientResponse.getResult().stream().map(r -> {
                FilterGroup group = new FilterGroup();
                group.setChecked(r.getChecked());
                group.setGroupId(r.getGroupId());
                group.setGroupName(r.getGroupName());
                group.setOrderNum(r.getOrderNum());
                List<Object> invoiceFilters = Lists.newArrayList();
                if (r.getList() != null) {
                    invoiceFilters = r.getList().stream().map(l -> this.toInvoiceFilter(l)).collect(Collectors.toList());
                }
                group.setList((List)invoiceFilters);
                return group;
            }).collect(Collectors.toList());
        }
        response.setResult((List)filterGroups);
        return response;
    }

    private InvoiceFilter toInvoiceFilter(MsInvoiceFilter filter) {
        InvoiceFilter invoiceFilter = new InvoiceFilter();
        invoiceFilter.setControlId(filter.getControlId());
        invoiceFilter.setKey(filter.getKey());
        invoiceFilter.setLabel(filter.getLabel());
        invoiceFilter.setType(filter.getType());
        invoiceFilter.setValue(filter.getValue());
        invoiceFilter.setCondition(filter.getCondition());
        return invoiceFilter;
    }

    private MsInvoiceFilter toMsInvoiceFilter(InvoiceFilter filter) {
        MsInvoiceFilter invoiceFilter = new MsInvoiceFilter();
        invoiceFilter.setControlId(filter.getControlId());
        invoiceFilter.setKey(filter.getKey());
        invoiceFilter.setLabel(filter.getLabel());
        invoiceFilter.setType(filter.getType());
        invoiceFilter.setValue(filter.getValue());
        invoiceFilter.setCondition(filter.getCondition());
        return invoiceFilter;
    }

    public GeneralResponse deleteFilterGroup(Long groupId) {
        GeneralResponse response = new GeneralResponse();
        logger.info("deleteFilterGroup: input param: " + groupId);
        MsGeneralResponse clientResponse = this.filterClient.deleteFilterGroup(groupId);
        logger.info("deleteFilterGroup: return value: code:{},message:{}", (Object)clientResponse.getCode(), (Object)clientResponse.getMessage());
        return response.code(clientResponse.getCode()).message(clientResponse.getMessage()).result(clientResponse.getResult());
    }

    public GeneralResponse insertFilterGroup(Integer resourceType, UserSessionInfo userSessionInfo) {
        GeneralResponse response = new GeneralResponse();
        MsFilterGroupRequest clientRequest = new MsFilterGroupRequest();
        clientRequest.setResourceType(resourceType);
        clientRequest.setUserId(Long.valueOf(userSessionInfo.getSysUserId()));
        clientRequest.setUserName(userSessionInfo.getSysUserName());
        logger.info("insertFilterGroup: input param: " + clientRequest.toString());
        MsGeneralResponse clientResponse = this.filterClient.insertFilterGroup(clientRequest);
        logger.info("insertFilterGroup: return value: code:{},message:{}", (Object)clientResponse.getCode(), (Object)clientResponse.getMessage());
        return response.code(clientResponse.getCode()).message(clientResponse.getMessage()).result(clientResponse.getResult());
    }

    public GeneralResponse updateFilterCondition(FilterConditionInfoRequest request) {
        GeneralResponse response = new GeneralResponse();
        MsFilterConditionInfoRequest clientRequest = new MsFilterConditionInfoRequest();
        clientRequest.setGroupId(request.getGroupId());
        List<Object> controlList = Lists.newArrayList();
        if (request.getControlList() != null) {
            controlList = request.getControlList().stream().map(r -> this.toMsInvoiceFilter(r)).collect(Collectors.toList());
        }
        clientRequest.setControlList((List)controlList);
        logger.info("updateFilterCondition: input param: " + clientRequest.toString());
        MsGeneralResponse clientResponse = this.filterClient.updateFilterCondition(clientRequest);
        logger.info("updateFilterCondition: return value: code:{},message:{}", (Object)clientResponse.getCode(), (Object)clientResponse.getMessage());
        return response.code(clientResponse.getCode()).message(clientResponse.getMessage()).result(clientResponse.getResult());
    }

    public GeneralResponse updateFilterGroup(List<FilterGroupInfoRequest> request) {
        GeneralResponse response = new GeneralResponse();
        List clientRequest = request.stream().map(r -> {
            MsFilterGroupInfoRequest infoRequest = new MsFilterGroupInfoRequest();
            infoRequest.setGroupId(r.getGroupId());
            infoRequest.setGroupName(r.getGroupName());
            infoRequest.setOrderNum(r.getOrderNum());
            return infoRequest;
        }).collect(Collectors.toList());
        logger.info("updateFilterGroup: input param: " + clientRequest.toString());
        MsGeneralResponse clientResponse = this.filterClient.updateFilterGroup(clientRequest);
        logger.info("updateFilterGroup: return value: code:{},message:{}", (Object)clientResponse.getCode(), (Object)clientResponse.getMessage());
        return response.code(clientResponse.getCode()).message(clientResponse.getMessage()).result(clientResponse.getResult());
    }

    public GeneralResponse searchCompany(SearchCompanyRequest request, UserSessionInfo userSessionInfo) {
        GeneralResponse response = new GeneralResponse();
        List<Object> companyList = Lists.newArrayList();
        if (request.getSearchType() == null) {
            return response.code(PurconfigConstant.PurconfigReqCodeEnum.FAIL.code()).message("searchType\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (1 == request.getSearchType()) {
            MsListCasRequest casRequest = new MsListCasRequest();
            casRequest.casType(Integer.valueOf(2));
            casRequest.setGroupid(Long.valueOf(userSessionInfo.getGroupId()));
            casRequest.setOperatorId(Long.valueOf(userSessionInfo.getSysUserId()));
            if (!CommonTools.isEmpty((String)request.getCompanyName())) {
                casRequest.setParam(request.getCompanyName());
            }
            casRequest.setCurrentPage(PurconfigConstant.NumberEnum.NUMBER_ONE.getValue());
            casRequest.setPageSize(PurconfigConstant.NumberEnum.NUMBER_1000.getValue());
            logger.info("searchCompany: input param: " + casRequest.toString());
            MsListCasResult casResult = this.casmIndexClient.listCas(casRequest);
            logger.info("searchCompany: return value: code:{},message:{}", (Object)casResult.getCode(), (Object)casResult.getMessage());
            if (PurconfigConstant.PurconfigReqCodeEnum.SUCCESS.code().equals(casResult.getCode()) && casResult.getResult() != null) {
                if (casResult.getResult().getSuppliersTotal() > PurconfigConstant.NumberEnum.NUMBER_1000.getValue()) {
                    casRequest.setPageSize(casResult.getResult().getSuppliersTotal());
                    casResult = this.casmIndexClient.listCas(casRequest);
                }
                companyList = casResult.getResult().getCasInfos().stream().map(r -> r.getEnterpriseName()).collect(Collectors.toList());
                response.code(PurconfigConstant.PurconfigReqCodeEnum.SUCCESS.code()).message(PurconfigConstant.PurconfigReqCodeEnum.SUCCESS.message()).result((Object)companyList);
            } else {
                response.code(casResult.getCode()).message(casResult.getMessage()).result((Object)companyList);
            }
        } else if (2 == request.getSearchType()) {
            SearchCompanyListRequest clientRequest = new SearchCompanyListRequest();
            clientRequest.setAppid("phoenix-purconfig-app");
            clientRequest.setDataType(SearchCompanyListRequest.DataTypeEnum.COMPANYNAME);
            clientRequest.setDataValue(request.getCompanyName());
            clientRequest.setGroupId(Long.valueOf(userSessionInfo.getGroupId()));
            clientRequest.setPage(PurconfigConstant.NumberEnum.NUMBER_ONE.getValue());
            clientRequest.setRow(PurconfigConstant.NumberEnum.NUMBER_1000.getValue());
            clientRequest.setRid(userSessionInfo.getSysUserId() + "");
            logger.info("searchCompany: input param: " + clientRequest.toString());
            SearchCompanyListResponse clientResponse = this.companyClient.searchCompanyList(clientRequest);
            logger.info("searchCompany: return value: code:{},message:{}", (Object)clientResponse.getCode(), (Object)clientResponse.getMessage());
            if (PurconfigConstant.PurconfigReqCodeEnum.SUCCESS.code().equals(clientResponse.getCode()) && clientResponse.getResult() != null) {
                if (clientResponse.getTotal() > (long)PurconfigConstant.NumberEnum.NUMBER_1000.getValue().intValue()) {
                    clientRequest.setRow(Integer.valueOf(clientResponse.getTotal().intValue()));
                    clientResponse = this.companyClient.searchCompanyList(clientRequest);
                }
                companyList = clientResponse.getResult().stream().map(r -> r.getCompanyName()).collect(Collectors.toList());
                response.code(PurconfigConstant.PurconfigReqCodeEnum.SUCCESS.code()).message(PurconfigConstant.PurconfigReqCodeEnum.SUCCESS.message()).result((Object)companyList);
            } else {
                response.code(clientResponse.getCode()).message(clientResponse.getMessage()).result((Object)companyList);
            }
        } else {
            return response.code(PurconfigConstant.PurconfigReqCodeEnum.FAIL.code()).message("searchType\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u53ea\u80fd\u4e3a1\u62162");
        }
        return response;
    }

    public InvoiceInfoResponse importInvoiceData(ImportInvoiceDataRequest request, UserSessionInfo userSessionInfo) {
        List orgIdList;
        logger.info("importInvoiceData: upload return value: " + request);
        InvoiceInfoResponse response = new InvoiceInfoResponse();
        String fileUrl = "";
        if (request.getFileInfoList() != null) {
            ImportFileInfo fileInfo = (ImportFileInfo)request.getFileInfoList().get(0);
            fileUrl = fileInfo.getFileDirectory() + fileInfo.getUploadFileName();
        }
        if (CommonUtils.isEmpty((List)(orgIdList = this.getOrgIdList(Long.valueOf(userSessionInfo.getGroupId()), Long.valueOf(userSessionInfo.getSysUserId()), null)))) {
            return response.code(PurconfigConstant.PurconfigReqCodeEnum.FAIL.code()).message("\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u6743\u9650\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        MsImportInvoiceRequest clientRequest = new MsImportInvoiceRequest();
        clientRequest.setFileUrl(fileUrl);
        clientRequest.setOrgIdList(orgIdList);
        clientRequest.setGroupId(Long.valueOf(userSessionInfo.getGroupId()));
        clientRequest.setSysUserId(Long.valueOf(userSessionInfo.getSysUserId()));
        clientRequest.setSysUserName(userSessionInfo.getSysUserName());
        logger.info("importInvoiceData: input param: " + clientRequest);
        MsInvoiceInfoResponse clientResponse = this.filterClient.importInvoiceData(clientRequest);
        logger.info("importInvoiceData: return value: code:{},message:{}", (Object)clientResponse.getCode(), (Object)clientResponse.getMessage());
        InvoiceInfoObj invoiceInfoObj = new InvoiceInfoObj();
        if (clientResponse.getResult() != null) {
            MsInvoiceInfoObj msInvoiceInfoObj = clientResponse.getResult();
            invoiceInfoObj.setSuccessNum(msInvoiceInfoObj.getSuccessNum());
            invoiceInfoObj.setFailNum(msInvoiceInfoObj.getFailNum());
            List<Object> invoiceObjs = Lists.newArrayList();
            if (msInvoiceInfoObj.getInvoiceList() != null) {
                invoiceObjs = msInvoiceInfoObj.getInvoiceList().stream().map(r -> {
                    InvoiceObj invoiceObj = new InvoiceObj();
                    invoiceObj.setInvoiceCode(r.getInvoiceCode());
                    invoiceObj.setInvoiceNo(r.getInvoiceNo());
                    return invoiceObj;
                }).collect(Collectors.toList());
            }
            invoiceInfoObj.setInvoiceList((List)invoiceObjs);
        }
        return response.code(clientResponse.getCode()).message(clientResponse.getMessage()).result(invoiceInfoObj);
    }

    public FilterTemplateResponse downloadFilterTemplate() {
        FilterTemplateResponse response = new FilterTemplateResponse();
        MsFilterTemplateResponse clientResponse = this.filterClient.downloadFilterTemplate();
        response.setCode(clientResponse.getCode());
        response.setMessage(clientResponse.getMessage());
        List<Object> modelList = Lists.newArrayList();
        if (clientResponse.getResult() != null) {
            List list = clientResponse.getResult();
            modelList = list.stream().map(r -> {
                DownloadTemplateModel model = new DownloadTemplateModel();
                model.setFileDisplayName(r.getFileDisplayName());
                model.setKey(r.getKey());
                return model;
            }).collect(Collectors.toList());
        }
        response.setResult((List)modelList);
        return response;
    }

    public List<Long> getOrgIdList(Long groupId, Long sysUserId, Integer orgType) {
        List<Object> orgIdList = Lists.newArrayList();
        GetOrgListRequest clientRequest = new GetOrgListRequest();
        clientRequest.setAppid("phoenix-purconfig-app");
        clientRequest.setRid(sysUserId.toString());
        clientRequest.setGroupID(groupId);
        if (orgType != null) {
            clientRequest.setSingleOrgType(orgType);
        }
        if (sysUserId != null) {
            clientRequest.setUserID(sysUserId);
        }
        clientRequest.setPage(PurconfigConstant.NumberEnum.NUMBER_ZERO.getValue());
        clientRequest.setRow(PurconfigConstant.NumberEnum.NUMBER_1000.getValue());
        logger.info("getOrgIdList: input param: " + clientRequest.toString());
        GetOrgListResponse clientResponse = this.orgClient.getOrgList(clientRequest);
        logger.info("getOrgIdList: return value: " + JsonUtils.writeObjectToJson((Object)clientResponse));
        if (PurconfigConstant.PurconfigReqCodeEnum.SUCCESS.code().equals(clientResponse.getCode()) && clientResponse.getResult() != null) {
            if (clientResponse.getTotal() > (long)PurconfigConstant.NumberEnum.NUMBER_1000.getValue().intValue()) {
                clientRequest.setRow(Integer.valueOf(clientResponse.getTotal().intValue()));
                clientResponse = this.orgClient.getOrgList(clientRequest);
            }
            orgIdList = clientResponse.getResult().stream().filter(r -> r.getStatus() == 1).map(r -> r.getOrgStructId()).collect(Collectors.toList());
        }
        return orgIdList;
    }
}

