/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purconfig.app.service;

import com.google.common.collect.Lists;
import com.xforceplus.purchaser.common.utils.JsonUtils;
import com.xforceplus.purconfig.app.client.OrgClient;
import com.xforceplus.purconfig.app.service.OrgService;
import com.xforceplus.ucenter.external.client.model.GetOrgListRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgListResponse;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatframework.enums.ErrorCodeEnum;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrgServiceImpl
implements OrgService {
    private static final Logger log = LoggerFactory.getLogger(OrgServiceImpl.class);
    @Autowired
    private OrgClient orgClient;

    public List<Long> getOrgIdList(UserSessionInfo userSessionInfo) {
        ArrayList orgIdList = Lists.newArrayList();
        GetOrgListRequest clientRequest = new GetOrgListRequest();
        clientRequest.setAppid("phoenix-purconfig-app");
        clientRequest.setRid(UUID.randomUUID().toString());
        clientRequest.setGroupID(Long.valueOf(userSessionInfo.getGroupId()));
        clientRequest.setUserID(Long.valueOf(userSessionInfo.getSysUserId()));
        this.getOrgIdList(clientRequest, 1, 100, (List)orgIdList);
        log.info("##### \u83b7\u53d6\u6743\u9650\u7ec4\u7ec7\u5217\u8868\u7ed3\u679c\uff0corgIdList\uff1a{}", (Object)orgIdList);
        return orgIdList;
    }

    private List<Long> getOrgIdList(GetOrgListRequest clientRequest, int page, int rowNum, List<Long> orgIdList) {
        clientRequest.setPage(Integer.valueOf(page));
        clientRequest.setRow(Integer.valueOf(rowNum));
        log.info("##### getOrgIdList: input param: {}", (Object)clientRequest);
        GetOrgListResponse clientResponse = this.orgClient.getOrgList(clientRequest);
        log.info("##### getOrgIdList: return value: {}", (Object)clientResponse);
        if (clientResponse == null || clientResponse.getCode() != 1) {
            return orgIdList;
        }
        List orgModelList = clientResponse.getResult();
        if (CollectionUtils.isEmpty((Collection)orgModelList)) {
            return orgIdList;
        }
        for (OrgModel orgModel : orgModelList) {
            orgIdList.add(orgModel.getOrgStructId());
        }
        if (clientResponse.getTotal() > (long)orgIdList.size()) {
            this.getOrgIdList(clientRequest, page + 1, rowNum, orgIdList);
        }
        return orgIdList;
    }

    public List<OrgModel> getOrgInfoList(UserSessionInfo userSessionInfo) {
        Long groupId = userSessionInfo.getGroupId();
        Long sysUserId = userSessionInfo.getSysUserId();
        Integer orgType = 1;
        List orgList = Lists.newArrayList();
        GetOrgListRequest clientRequest = new GetOrgListRequest();
        clientRequest.setAppid("phoenix-auth-app");
        clientRequest.setRid(sysUserId.toString());
        clientRequest.setGroupID(groupId);
        if (orgType != null) {
            clientRequest.setSingleOrgType(orgType);
        }
        if (sysUserId != null) {
            clientRequest.setUserID(sysUserId);
        }
        clientRequest.setPage(Integer.valueOf(0));
        clientRequest.setRow(Integer.valueOf(1000));
        log.info("getOrgIdList: input param: {}", (Object)JsonUtils.writeObjectToJson((Object)clientRequest));
        GetOrgListResponse clientResponse = this.orgClient.getOrgList(clientRequest);
        log.info("getOrgIdList: return value: " + JsonUtils.writeObjectToJson((Object)clientResponse));
        if (clientResponse.getCode().intValue() == ErrorCodeEnum.SUCCESS.code() && clientResponse.getResult() != null) {
            if (clientResponse.getTotal() > 1000L) {
                clientRequest.setRow(Integer.valueOf(clientResponse.getTotal().intValue()));
                clientResponse = this.orgClient.getOrgList(clientRequest);
            }
            orgList = clientResponse.getResult();
        }
        return orgList;
    }
}

