/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purconfig.app.service;

import com.xforceplus.purconfig.app.client.RuleGroupClient;
import com.xforceplus.purconfig.app.model.BatchRuleGroupModel;
import com.xforceplus.purconfig.app.model.GeneralResponse;
import com.xforceplus.purconfig.app.model.GetRuleGroupByDistinctNameRequest;
import com.xforceplus.purconfig.app.model.GetRuleGroupRequest;
import com.xforceplus.purconfig.app.model.GetRuleGroupResponse;
import com.xforceplus.purconfig.app.model.PcfRuleGroupModel;
import com.xforceplus.purconfig.app.model.SearchRuleGroupRequest;
import com.xforceplus.purconfig.app.service.RuleGroupAppService;
import com.xforceplus.purconfig.app.utils.ContextUtils;
import com.xforceplus.purconfig.client.model.MsBatchSenseWordModel;
import com.xforceplus.purconfig.client.model.MsGeneralResponse;
import com.xforceplus.purconfig.client.model.MsGetRuleGroupRequest;
import com.xforceplus.purconfig.client.model.MsGetRuleGroupResponse;
import com.xforceplus.purconfig.client.model.MsPcfRuleGroupModel;
import com.xforceplus.purconfig.client.model.MsPcfRuleModel;
import com.xforceplus.purconfig.client.model.MsSearchRuleGroupRequest;
import com.xforceplus.purconfig.client.model.Response;
import com.xforceplus.xplatframework.exception.ResultCode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RuleGroupAppServiceImpl
implements RuleGroupAppService {
    private static final Logger logger = LoggerFactory.getLogger(RuleGroupAppServiceImpl.class);
    @Autowired
    private RuleGroupClient ruleGroupClient;
    @Autowired
    private ContextUtils contextUtils;

    public GeneralResponse createRuleGroup(PcfRuleGroupModel request) {
        GeneralResponse generalResponse = new GeneralResponse();
        MsPcfRuleGroupModel msModel = new MsPcfRuleGroupModel();
        logger.info("createRuleGroup: input param: " + request.toString());
        msModel.setRuleGroupCode(request.getRuleGroupCode());
        msModel.setRuleGroupName(request.getRuleGroupName());
        msModel.setTriggerPoint(request.getTriggerPoint());
        msModel.setGroupId(request.getGroupId());
        msModel.setRuleGroupStatus(request.getRuleGroupStatus());
        msModel.setRuleGroupPriority(request.getRuleGroupPriority());
        msModel.setRuleGroupType(request.getRuleGroupType());
        msModel.setCreateUserId(this.contextUtils.getUserId());
        msModel.setCreateUserName(request.getCreateUserName());
        msModel.setRuleContent(request.getRuleContent());
        MsGeneralResponse msGeneralResponse = this.ruleGroupClient.checkRuleGroupConflict(msModel);
        if (!msGeneralResponse.getCode().equals(ResultCode.SUCCESS.getCode())) {
            generalResponse.setCode(msGeneralResponse.getCode());
            generalResponse.setMessage(msGeneralResponse.getMessage());
            generalResponse.setResult(msGeneralResponse.getResult());
            return generalResponse;
        }
        Response msResponse = this.ruleGroupClient.createRuleGroup(msModel);
        logger.info("createRuleGroup: return value: " + msGeneralResponse.toString());
        if (!ResultCode.SUCCESS.getCode().equals(msResponse.getCode()) || null == msResponse.getResult()) {
            generalResponse.setCode(msResponse.getCode());
            generalResponse.setMessage(msResponse.getMessage());
            generalResponse.setResult(msResponse.getResult());
            return generalResponse;
        }
        Long createdId = (Long)msResponse.getResult();
        MsPcfRuleModel msPcfRuleModel = new MsPcfRuleModel();
        msPcfRuleModel.setRuleGroupId(createdId.toString());
        msPcfRuleModel.setTriggerPoint(request.getTriggerPoint());
        if (request.getDefaultConfig() != null) {
            msPcfRuleModel.setDefaultConfig(request.getDefaultConfig());
        }
        msPcfRuleModel.setRuleContent(request.getRuleContent());
        msPcfRuleModel.setGroupId(request.getGroupId());
        Response attachRuleToRuleGroupResponse = this.ruleGroupClient.attachRuleToRuleGroup(msPcfRuleModel);
        logger.info("createBatchRuleGroup: attachRuleToRuleGroup return value: " + attachRuleToRuleGroupResponse.toString());
        generalResponse.setCode(msGeneralResponse.getCode());
        generalResponse.setMessage(msGeneralResponse.getMessage());
        generalResponse.setResult(msGeneralResponse.getResult());
        return generalResponse;
    }

    public GeneralResponse deleteRuleGroup(PcfRuleGroupModel request) {
        GeneralResponse generalResponse = new GeneralResponse();
        MsPcfRuleGroupModel model = new MsPcfRuleGroupModel();
        logger.info("deleteRuleGroup: input param: " + request.toString());
        model.setId(request.getId());
        MsGeneralResponse msGeneralResponse = this.ruleGroupClient.deleteRuleGroup(model);
        logger.info("deleteRuleGroup: return value: " + msGeneralResponse.toString());
        generalResponse.setCode(msGeneralResponse.getCode());
        generalResponse.setMessage(msGeneralResponse.getMessage());
        generalResponse.setResult(msGeneralResponse.getResult());
        return generalResponse;
    }

    public GetRuleGroupResponse getRuleGroup(GetRuleGroupRequest request) {
        GetRuleGroupResponse getGeneralResponse = new GetRuleGroupResponse();
        MsGetRuleGroupRequest msRequest = new MsGetRuleGroupRequest();
        logger.info("getRuleGroup: input param: " + request.toString());
        msRequest.setTriggerPoint(request.getTriggerPoint());
        msRequest.setGroupId(request.getGroupId());
        msRequest.setDefaultConfig(request.getDefaultConfig());
        msRequest.setId(request.getId());
        msRequest.setRuleGroupCode(request.getRuleGroupCode());
        msRequest.setRuleGroupStatus(request.getRuleGroupStatus());
        msRequest.setRuleGroupName(request.getRuleGroupName());
        MsGetRuleGroupResponse msResponse = this.ruleGroupClient.getRuleGroup(msRequest);
        logger.info("getRuleGroup: return value: " + msResponse.toString());
        getGeneralResponse.setCode(msResponse.getCode());
        getGeneralResponse.setMessage(msResponse.getMessage());
        List msModels = msResponse.getResult();
        ArrayList<PcfRuleGroupModel> models = new ArrayList<PcfRuleGroupModel>();
        for (MsPcfRuleGroupModel msModel : msModels) {
            PcfRuleGroupModel model = new PcfRuleGroupModel();
            model.setId(msModel.getId().toString());
            model.setGroupId(msModel.getGroupId().toString());
            model.setRuleGroupCode(msModel.getRuleGroupCode());
            model.setRuleGroupName(msModel.getRuleGroupName());
            model.setRuleGroupComment(msModel.getRuleGroupComment());
            model.setRuleGroupStatus(msModel.getRuleGroupStatus().toString());
            model.setRuleGroupType(msModel.getRuleGroupType().toString());
            model.setRuleGroupPriority(msModel.getRuleGroupPriority().toString());
            model.setTriggerPoint(msModel.getTriggerPoint());
            model.setRuleContent(msModel.getRuleContent());
            model.setCreateTime(msModel.getCreateTime());
            model.setCreateUserName(msModel.getCreateUserName());
            model.setCreateUserId(msModel.getCreateUserId().toString());
            models.add(model);
        }
        getGeneralResponse.setResult(models);
        return getGeneralResponse;
    }

    public GetRuleGroupResponse getRuleGroupByDistinctName(GetRuleGroupByDistinctNameRequest request) {
        GetRuleGroupResponse getGeneralResponse = new GetRuleGroupResponse();
        MsGetRuleGroupRequest msRequest = new MsGetRuleGroupRequest();
        logger.info("getRuleGroupByDistinctName: input param: " + request.toString());
        msRequest.setGroupId(request.getGroupId());
        msRequest.setRuleGroupCode(request.getRuleGroupCode());
        MsGetRuleGroupResponse msResponse = this.ruleGroupClient.getRuleGroupByGroupId(msRequest);
        logger.info("getRuleGroup: return value: " + msResponse.toString());
        getGeneralResponse.setCode(msResponse.getCode());
        getGeneralResponse.setMessage(msResponse.getMessage());
        List msModels = msResponse.getResult();
        ArrayList<PcfRuleGroupModel> models = new ArrayList<PcfRuleGroupModel>();
        for (MsPcfRuleGroupModel msModel : msModels) {
            PcfRuleGroupModel model = new PcfRuleGroupModel();
            model.setId(msModel.getId());
            model.setGroupId(msModel.getGroupId());
            model.setRuleGroupCode(msModel.getRuleGroupCode());
            model.setRuleGroupName(msModel.getRuleGroupName());
            model.setRuleGroupComment(msModel.getRuleGroupComment());
            model.setRuleGroupStatus(msModel.getRuleGroupStatus());
            model.setRuleGroupType(msModel.getRuleGroupType());
            model.setRuleGroupPriority(msModel.getRuleGroupPriority());
            model.setCreateTime(msModel.getCreateTime());
            model.setCreateUserName(msModel.getCreateUserName());
            model.setUpdateUserId(msModel.getUpdateUserId());
            model.setUpdateUserName(msModel.getUpdateUserName());
            model.setUpdateTime(msModel.getUpdateTime());
            models.add(model);
        }
        getGeneralResponse.setResult(models);
        return getGeneralResponse;
    }

    public GeneralResponse updateRuleGroup(PcfRuleGroupModel request) {
        GeneralResponse generalResponse = new GeneralResponse();
        logger.info("updateRuleGroup: input param: " + request.toString());
        MsPcfRuleGroupModel msPcfRuleGroupModel = new MsPcfRuleGroupModel();
        msPcfRuleGroupModel.setId(request.getId());
        msPcfRuleGroupModel.setRuleGroupName(request.getRuleGroupName());
        msPcfRuleGroupModel.setCreateUserName(request.getCreateUserName());
        msPcfRuleGroupModel.setRuleGroupComment(request.getRuleGroupComment());
        msPcfRuleGroupModel.setRuleGroupType(request.getRuleGroupType());
        msPcfRuleGroupModel.setRuleGroupStatus(request.getRuleGroupStatus());
        msPcfRuleGroupModel.setRuleGroupPriority(request.getRuleGroupPriority());
        msPcfRuleGroupModel.setTriggerPoint(request.getTriggerPoint());
        msPcfRuleGroupModel.setRuleContent(request.getRuleContent());
        msPcfRuleGroupModel.setCreateUserId(this.contextUtils.getUserId());
        msPcfRuleGroupModel.setRuleGroupStatus(request.getRuleGroupStatus());
        msPcfRuleGroupModel.setGroupId(request.getGroupId());
        MsGeneralResponse msGeneralResponse = this.ruleGroupClient.checkRuleGroupConflict(msPcfRuleGroupModel);
        if (!msGeneralResponse.getCode().equals(ResultCode.SUCCESS.getCode())) {
            generalResponse.setCode(msGeneralResponse.getCode());
            generalResponse.setMessage(msGeneralResponse.getMessage());
            generalResponse.setResult(msGeneralResponse.getResult());
            return generalResponse;
        }
        msGeneralResponse = this.ruleGroupClient.updateRuleGroup(msPcfRuleGroupModel);
        logger.info("updateRuleGroup: return value: " + msGeneralResponse.toString());
        generalResponse.setCode(msGeneralResponse.getCode());
        generalResponse.setMessage(msGeneralResponse.getMessage());
        generalResponse.setResult(msGeneralResponse.getResult());
        return generalResponse;
    }

    public GeneralResponse updateBatchRuleGroup(BatchRuleGroupModel request) {
        ArrayList<Long> failureIds = new ArrayList<Long>();
        GeneralResponse generalResponse = new GeneralResponse();
        logger.info("updateBatchRuleGroup: input param: " + request.toString());
        ArrayList<MsPcfRuleGroupModel> msPcfRuleGroupModelList = new ArrayList<MsPcfRuleGroupModel>();
        for (PcfRuleGroupModel model : request.getData()) {
            MsPcfRuleGroupModel msPcfRuleGroupModel = new MsPcfRuleGroupModel();
            msPcfRuleGroupModel.setId(model.getId());
            msPcfRuleGroupModel.setGroupId(model.getGroupId());
            msPcfRuleGroupModel.setRuleGroupCode(model.getRuleGroupCode());
            msPcfRuleGroupModel.setRuleGroupName(model.getRuleGroupName());
            msPcfRuleGroupModel.setRuleGroupComment(model.getRuleGroupComment());
            msPcfRuleGroupModel.setRuleGroupStatus(model.getRuleGroupStatus());
            msPcfRuleGroupModel.setRuleGroupType(model.getRuleGroupType());
            msPcfRuleGroupModel.setRuleGroupPriority(model.getRuleGroupPriority());
            msPcfRuleGroupModel.setTriggerPoint(model.getTriggerPoint());
            msPcfRuleGroupModel.setRuleContent(model.getRuleContent());
            msPcfRuleGroupModel.setUpdateUserId(this.contextUtils.getUserId());
            msPcfRuleGroupModel.setUpdateUserName(this.contextUtils.getUserName());
            msPcfRuleGroupModelList.add(msPcfRuleGroupModel);
        }
        for (MsPcfRuleGroupModel msModel : msPcfRuleGroupModelList) {
            logger.info("updateBatchRuleGroup: [updateRuleGroup]  input param: " + msModel.toString());
            MsGeneralResponse msGeneralResponse = this.ruleGroupClient.updateRuleGroup(msModel);
            logger.info("updateBatchRuleGroup: [updateRuleGroup]  return value: " + msGeneralResponse.toString());
            if (msGeneralResponse.getCode().equals(ResultCode.SUCCESS.getCode())) continue;
            failureIds.add(Long.parseLong(msModel.getId()));
        }
        if (failureIds.size() > 0) {
            generalResponse.setCode(Integer.valueOf(1));
            generalResponse.setMessage("\u90e8\u5206\u6570\u636e\u672a\u66f4\u65b0\u6210\u529f");
            generalResponse.setResult((Object)((Object)failureIds).toString());
        } else {
            generalResponse.setCode(ResultCode.SUCCESS.getCode());
            generalResponse.setMessage(ResultCode.SUCCESS.getMessage());
        }
        return generalResponse;
    }

    public GeneralResponse deleteBatchRuleGroup(BatchRuleGroupModel request) {
        GeneralResponse generalResponse = new GeneralResponse();
        MsBatchSenseWordModel msModels = new MsBatchSenseWordModel();
        logger.info("deleteBatchRuleGroup: input param: " + request.toString());
        for (PcfRuleGroupModel msModel : request.getData()) {
            MsPcfRuleGroupModel msPcfRuleGroupModel = new MsPcfRuleGroupModel();
            msPcfRuleGroupModel.setId(msModel.getId());
            MsGeneralResponse msGeneralResponse = this.ruleGroupClient.deleteRuleGroup(msPcfRuleGroupModel);
            logger.info("deleteBatchRuleGroup: return value: " + msGeneralResponse.toString());
        }
        generalResponse.setCode(ResultCode.SUCCESS.getCode());
        generalResponse.setMessage(ResultCode.SUCCESS.getMessage());
        return generalResponse;
    }

    public GeneralResponse createBatchRuleGroup(BatchRuleGroupModel request) {
        MsGeneralResponse msGeneralResponse;
        boolean ruleGroupCreated = false;
        GeneralResponse generalResponse = new GeneralResponse();
        logger.info("createBatchRuleGroup: input param: " + request.toString());
        Long createdId = 0L;
        ArrayList<MsPcfRuleGroupModel> msPcfRuleGroupModelList = new ArrayList<MsPcfRuleGroupModel>();
        for (PcfRuleGroupModel pcfRuleGroupModel : request.getData()) {
            MsPcfRuleGroupModel msPcfRuleGroupModel = new MsPcfRuleGroupModel();
            msPcfRuleGroupModel.setGroupId(pcfRuleGroupModel.getGroupId());
            msPcfRuleGroupModel.setRuleGroupCode(pcfRuleGroupModel.getRuleGroupCode());
            msPcfRuleGroupModel.setRuleGroupName(pcfRuleGroupModel.getRuleGroupName());
            msPcfRuleGroupModel.setRuleGroupComment(pcfRuleGroupModel.getRuleGroupComment());
            msPcfRuleGroupModel.setRuleGroupStatus(pcfRuleGroupModel.getRuleGroupStatus());
            msPcfRuleGroupModel.setRuleGroupType(pcfRuleGroupModel.getRuleGroupType());
            msPcfRuleGroupModel.setRuleGroupPriority(pcfRuleGroupModel.getRuleGroupPriority());
            msPcfRuleGroupModel.setTriggerPoint(pcfRuleGroupModel.getTriggerPoint());
            msPcfRuleGroupModel.setRuleContent(pcfRuleGroupModel.getRuleContent());
            msPcfRuleGroupModelList.add(msPcfRuleGroupModel);
        }
        for (MsPcfRuleGroupModel msPcfRuleGroupModel : msPcfRuleGroupModelList) {
            msGeneralResponse = this.ruleGroupClient.checkRuleGroupConflict(msPcfRuleGroupModel);
            if (msGeneralResponse.getCode().equals(ResultCode.SUCCESS.getCode())) continue;
            generalResponse.setCode(msGeneralResponse.getCode());
            generalResponse.setMessage(msGeneralResponse.getMessage());
            generalResponse.setResult(msGeneralResponse.getResult());
            return generalResponse;
        }
        for (MsPcfRuleGroupModel msPcfRuleGroupModel : msPcfRuleGroupModelList) {
            if (!ruleGroupCreated) {
                msGeneralResponse = this.ruleGroupClient.createRuleGroup(msPcfRuleGroupModel);
                logger.info("createBatchRuleGroup: return value: " + msGeneralResponse.toString());
                if (!msGeneralResponse.getCode().equals(ResultCode.SUCCESS.getCode()) || null == msGeneralResponse.getResult()) {
                    generalResponse.setCode(msGeneralResponse.getCode());
                    generalResponse.setMessage(msGeneralResponse.getMessage());
                    return generalResponse;
                }
                createdId = (Long)msGeneralResponse.getResult();
                ruleGroupCreated = true;
            }
            MsPcfRuleModel msPcfRuleModel = new MsPcfRuleModel();
            msPcfRuleModel.setRuleGroupId(createdId.toString());
            msPcfRuleModel.setTriggerPoint(msPcfRuleGroupModel.getTriggerPoint());
            if (msPcfRuleGroupModel.getDefaultConfig() != null) {
                msPcfRuleModel.setDefaultConfig(msPcfRuleGroupModel.getDefaultConfig());
            }
            msPcfRuleModel.setRuleContent(msPcfRuleGroupModel.getRuleContent());
            msPcfRuleModel.setGroupId(msPcfRuleGroupModel.getGroupId());
            Response msGeneralResponse2 = this.ruleGroupClient.attachRuleToRuleGroup(msPcfRuleModel);
            logger.info("createBatchRuleGroup: attachRuleToRuleGroup return value: " + msGeneralResponse2.toString());
        }
        generalResponse.setCode(ResultCode.SUCCESS.getCode());
        generalResponse.setMessage(ResultCode.SUCCESS.getMessage());
        return generalResponse;
    }

    public GetRuleGroupResponse searchRuleGroupByName(SearchRuleGroupRequest request) {
        GetRuleGroupResponse getGeneralResponse = new GetRuleGroupResponse();
        MsSearchRuleGroupRequest msRequest = new MsSearchRuleGroupRequest();
        logger.info("getRuleGroup: input param: " + request.toString());
        msRequest.setRuleGroupName(request.getRuleGroupName());
        msRequest.setGroupId(request.getGroupId());
        MsGetRuleGroupResponse msResponse = this.ruleGroupClient.searchRuleGroupByName(msRequest);
        logger.info("getRuleGroup: return value: " + msResponse.toString());
        getGeneralResponse.setCode(msResponse.getCode());
        getGeneralResponse.setMessage(msResponse.getMessage());
        List msModels = msResponse.getResult();
        ArrayList<PcfRuleGroupModel> models = new ArrayList<PcfRuleGroupModel>();
        for (MsPcfRuleGroupModel msModel : msModels) {
            PcfRuleGroupModel model = new PcfRuleGroupModel();
            model.setId(msModel.getId().toString());
            model.setGroupId(msModel.getGroupId().toString());
            model.setRuleGroupCode(msModel.getRuleGroupCode());
            model.setRuleGroupName(msModel.getRuleGroupName());
            model.setRuleGroupComment(msModel.getRuleGroupComment());
            model.setRuleGroupStatus(msModel.getRuleGroupStatus().toString());
            model.setRuleGroupType(msModel.getRuleGroupType().toString());
            model.setRuleGroupPriority(msModel.getRuleGroupPriority().toString());
            model.setTriggerPoint(msModel.getTriggerPoint());
            model.setRuleContent(msModel.getRuleContent());
            model.setCreateTime(msModel.getCreateTime());
            model.setCreateUserName(msModel.getCreateUserName());
            model.setCreateUserId(msModel.getCreateUserId().toString());
            models.add(model);
        }
        getGeneralResponse.setResult(models);
        return getGeneralResponse;
    }
}

