/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purconfig.app.service;

import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.purconfig.app.client.SenseWordClient;
import com.xforceplus.purconfig.app.model.BatchSenseWordModel;
import com.xforceplus.purconfig.app.model.GeneralResponse;
import com.xforceplus.purconfig.app.model.GetSenseWordRequest;
import com.xforceplus.purconfig.app.model.GetSenseWordResponse;
import com.xforceplus.purconfig.app.model.ImportFileInfo;
import com.xforceplus.purconfig.app.model.ImportSenseWordFileRequest;
import com.xforceplus.purconfig.app.model.SearchSenseWordRequest;
import com.xforceplus.purconfig.app.model.SenseWordModel;
import com.xforceplus.purconfig.app.service.SenseWordAppService;
import com.xforceplus.purconfig.client.model.MsBatchSenseWordModel;
import com.xforceplus.purconfig.client.model.MsGeneralResponse;
import com.xforceplus.purconfig.client.model.MsGetSenseWordRequest;
import com.xforceplus.purconfig.client.model.MsGetSenseWordResponse;
import com.xforceplus.purconfig.client.model.MsImportSenseWordFileRequest;
import com.xforceplus.purconfig.client.model.MsSearchSenseWordRequest;
import com.xforceplus.purconfig.client.model.MsSenseWordModel;
import com.xforceplus.xplatframework.exception.ResultCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SenseWordAppServiceImpl
implements SenseWordAppService {
    private static final Logger logger = LoggerFactory.getLogger(SenseWordAppServiceImpl.class);
    @Autowired
    private SenseWordClient senseWordClient;

    public GeneralResponse createBatchSenseWord(BatchSenseWordModel request) {
        MsBatchSenseWordModel msModels = new MsBatchSenseWordModel();
        GeneralResponse generalResponse = new GeneralResponse();
        logger.info("createBatchSenseWord: input param: " + request.toString());
        for (SenseWordModel model : request.getData()) {
            MsSenseWordModel msModel = new MsSenseWordModel();
            msModel.setId(model.getId());
            msModel.setGroupId(model.getGroupId());
            msModel.setSenseWord(model.getSenseWord());
            msModel.setStatus(model.getStatus());
            if (!CommonTools.isEmpty((String)model.getCreateUserName())) {
                msModel.setCreateUserName(model.getCreateUserName());
            }
            if (!CommonTools.isEmpty((String)model.getCreateUserId())) {
                msModel.setCreateUserId(model.getCreateUserId());
            }
            msModel.setRemark(model.getRemark());
            msModels.getData().add(msModel);
        }
        MsGeneralResponse msGeneralResponse = this.senseWordClient.createBatchSenseWord(msModels);
        generalResponse.setCode(msGeneralResponse.getCode());
        generalResponse.setMessage(msGeneralResponse.getMessage());
        generalResponse.setResult(msGeneralResponse.getResult());
        return generalResponse;
    }

    public GeneralResponse createSenseWord(SenseWordModel request) {
        GeneralResponse generalResponse = new GeneralResponse();
        MsSenseWordModel msModel = new MsSenseWordModel();
        logger.info("createSenseWord: input param: " + request.toString());
        msModel.setId(request.getId());
        msModel.setGroupId(request.getGroupId());
        msModel.setSenseWord(request.getSenseWord());
        msModel.setStatus(request.getStatus());
        msModel.setCreateTime(request.getCreateTime());
        msModel.setCreateUserName(request.getCreateUserName());
        msModel.setCreateUserId(request.getCreateUserId());
        msModel.setRemark(request.getRemark());
        MsGeneralResponse msGeneralResponse = this.senseWordClient.createSenseWord(msModel);
        generalResponse.setCode(msGeneralResponse.getCode());
        generalResponse.setMessage(msGeneralResponse.getMessage());
        generalResponse.setResult(msGeneralResponse.getResult());
        return generalResponse;
    }

    public GeneralResponse deleteBatchSenseWord(BatchSenseWordModel request) {
        MsBatchSenseWordModel msModels = new MsBatchSenseWordModel();
        GeneralResponse generalResponse = new GeneralResponse();
        logger.info("deleteBatchSenseWord: input param: " + request.toString());
        for (SenseWordModel model : request.getData()) {
            MsSenseWordModel msModel = new MsSenseWordModel();
            msModel.setId(model.getId());
            msModels.getData().add(msModel);
        }
        MsGeneralResponse msGeneralResponse = this.senseWordClient.deleteBatchSenseWord(msModels);
        generalResponse.setCode(msGeneralResponse.getCode());
        generalResponse.setMessage(msGeneralResponse.getMessage());
        generalResponse.setResult(msGeneralResponse.getResult());
        return generalResponse;
    }

    public GetSenseWordResponse getSenseWord(GetSenseWordRequest request) {
        GetSenseWordResponse getSenseWordResponse = new GetSenseWordResponse();
        MsGetSenseWordRequest msGetSenseWordRequest = new MsGetSenseWordRequest();
        logger.info("getSenseWord: input param: " + request.toString());
        msGetSenseWordRequest.setGroupId(request.getGroupId());
        MsGetSenseWordResponse msGetSenseWordResponse = new MsGetSenseWordResponse();
        msGetSenseWordResponse = this.senseWordClient.getSenseWord(msGetSenseWordRequest);
        logger.info("getSenseWord: output param: " + msGetSenseWordResponse.toString());
        for (MsSenseWordModel msModel : msGetSenseWordResponse.getResult()) {
            SenseWordModel model = new SenseWordModel();
            model.setId(msModel.getId());
            model.setGroupId(msModel.getGroupId());
            model.setSenseWord(msModel.getSenseWord());
            model.setStatus(msModel.getStatus());
            model.setCreateTime(msModel.getCreateTime());
            model.setCreateUserName(msModel.getCreateUserName());
            model.setCreateUserId(msModel.getCreateUserId());
            model.setRemark(msModel.getRemark());
            getSenseWordResponse.getResult().add(model);
        }
        getSenseWordResponse.setCode(msGetSenseWordResponse.getCode());
        getSenseWordResponse.setMessage(msGetSenseWordResponse.getMessage());
        return getSenseWordResponse;
    }

    public GeneralResponse updateBatchSenseWord(BatchSenseWordModel request) {
        MsBatchSenseWordModel msModels = new MsBatchSenseWordModel();
        GeneralResponse generalResponse = new GeneralResponse();
        logger.info("updateBatchSenseWord: input param: " + request.toString());
        for (SenseWordModel model : request.getData()) {
            MsSenseWordModel msModel = new MsSenseWordModel();
            msModel.setId(model.getId());
            msModel.setGroupId(model.getGroupId());
            msModel.setSenseWord(model.getSenseWord());
            msModel.setStatus(model.getStatus());
            msModel.setCreateUserName(model.getCreateUserName());
            msModel.setCreateUserId(model.getCreateUserId());
            msModel.setRemark(model.getRemark());
            msModels.getData().add(msModel);
        }
        MsGeneralResponse msGeneralResponse = this.senseWordClient.updateBatchSenseWord(msModels);
        generalResponse.setCode(msGeneralResponse.getCode());
        generalResponse.setMessage(msGeneralResponse.getMessage());
        generalResponse.setResult(msGeneralResponse.getResult());
        return generalResponse;
    }

    public GeneralResponse updateSenseWord(SenseWordModel request) {
        GeneralResponse generalResponse = new GeneralResponse();
        MsSenseWordModel msModel = new MsSenseWordModel();
        logger.info("updateSenseWord: input param: " + request.toString());
        msModel.setId(request.getId());
        msModel.setGroupId(request.getGroupId());
        msModel.setSenseWord(request.getSenseWord());
        msModel.setStatus(request.getStatus());
        msModel.setCreateUserName(request.getCreateUserName());
        msModel.setCreateUserId(request.getCreateUserId());
        msModel.setRemark(request.getRemark());
        MsGeneralResponse msGeneralResponse = this.senseWordClient.updateSenseWord(msModel);
        generalResponse.setCode(msGeneralResponse.getCode());
        generalResponse.setMessage(msGeneralResponse.getMessage());
        generalResponse.setResult(msGeneralResponse.getResult());
        return generalResponse;
    }

    public GeneralResponse deleteSenseWord(SenseWordModel request) {
        GeneralResponse generalResponse = new GeneralResponse();
        MsSenseWordModel msModel = new MsSenseWordModel();
        logger.info("deleteSenseWord: input param: " + request.toString());
        msModel.setId(request.getId());
        MsGeneralResponse msGeneralResponse = this.senseWordClient.deleteSenseWord(msModel);
        generalResponse.setCode(msGeneralResponse.getCode());
        generalResponse.setMessage(msGeneralResponse.getMessage());
        generalResponse.setResult(msGeneralResponse.getResult());
        return generalResponse;
    }

    public GeneralResponse importSenseWordFile(ImportSenseWordFileRequest request) {
        GeneralResponse generalResponse = new GeneralResponse();
        MsImportSenseWordFileRequest msModel = new MsImportSenseWordFileRequest();
        logger.info("importSenseWordFile: input param: " + request.toString());
        if (request.getFileInfoList().size() <= 0) {
            generalResponse.setCode(ResultCode.FILE_UPLOAD_ERROR.getCode());
            generalResponse.setMessage(ResultCode.FILE_UPLOAD_ERROR.getMessage());
            return generalResponse;
        }
        msModel.setOssPath(((ImportFileInfo)request.getFileInfoList().get(0)).getFileDirectory() + ((ImportFileInfo)request.getFileInfoList().get(0)).getUploadFileName());
        msModel.setGroupId(request.getGroupId());
        msModel.setCreateUserId(request.getCreateUserId());
        msModel.setCreateUserName(request.getCreateUserName());
        MsGeneralResponse msGeneralResponse = this.senseWordClient.importSenseWordFile(msModel);
        generalResponse.setCode(msGeneralResponse.getCode());
        generalResponse.setMessage(msGeneralResponse.getMessage());
        generalResponse.setResult(msGeneralResponse.getResult());
        return generalResponse;
    }

    public GetSenseWordResponse searchSenseWord(SearchSenseWordRequest request) {
        GetSenseWordResponse getSenseWordResponse = new GetSenseWordResponse();
        MsSearchSenseWordRequest msSearchSenseWordRequest = new MsSearchSenseWordRequest();
        logger.info("getSenseWord: input param: " + request.toString());
        msSearchSenseWordRequest.setGroupId(request.getGroupId());
        msSearchSenseWordRequest.setSenseWord(request.getSenseWord());
        MsGetSenseWordResponse msGetSenseWordResponse = this.senseWordClient.searchSenseWord(msSearchSenseWordRequest);
        for (MsSenseWordModel msModel : msGetSenseWordResponse.getResult()) {
            SenseWordModel model = new SenseWordModel();
            model.setId(msModel.getId());
            model.setGroupId(msModel.getGroupId());
            model.setSenseWord(msModel.getSenseWord());
            model.setStatus(msModel.getStatus());
            model.setCreateUserName(msModel.getCreateUserName());
            model.setCreateUserId(msModel.getCreateUserId());
            model.setRemark(msModel.getRemark());
            getSenseWordResponse.getResult().add(model);
        }
        getSenseWordResponse.setCode(msGetSenseWordResponse.getCode());
        getSenseWordResponse.setMessage(msGetSenseWordResponse.getMessage());
        return getSenseWordResponse;
    }
}

