/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.purconfig.app.utils;

import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextUtils {
    private static final Logger log = LoggerFactory.getLogger(ContextUtils.class);
    public static final Long SYS_USER_ID = 0L;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    public UserContext getUserInfo() {
        return (UserContext)this.contextHolder.get();
    }

    public UserSessionInfo getUserSessionInfo() {
        if (this.getUserInfo() != null) {
            return this.getUserInfo().getUserSessionInfo();
        }
        return null;
    }

    public Long getUserId() {
        if (this.getUserSessionInfo() != null) {
            return this.getUserSessionInfo().getSysUserId();
        }
        return null;
    }

    public Long getGroupId() {
        if (this.getUserSessionInfo() != null) {
            return this.getUserSessionInfo().getGroupId();
        }
        return null;
    }

    public String getGroupName() {
        if (this.getUserSessionInfo() != null) {
            return this.getUserSessionInfo().getGroupName();
        }
        return null;
    }

    public String getGroupCode() {
        if (this.getUserSessionInfo() != null) {
            return this.getUserSessionInfo().getGroupCode();
        }
        return null;
    }

    public String getUserName() {
        if (this.getUserSessionInfo() != null) {
            return this.getUserSessionInfo().getSysUserName();
        }
        return null;
    }

    public Long userIdNullas0() {
        if (this.getUserId() == null) {
            return SYS_USER_ID;
        }
        return this.getUserId();
    }

    public Long groupIdNullAs0() {
        return this.getGroupId() == null ? 0L : this.getGroupId();
    }

    public String userNameNullAsEmpty() {
        return StringUtils.isEmpty((String)this.getUserName()) ? "" : this.getUserName();
    }

    public String groupNameNullAsEmpty() {
        return StringUtils.isEmpty((String)this.getGroupName()) ? "GROUP" : this.getGroupName();
    }

    public String groupCodeNullAsEmpty() {
        return StringUtils.isEmpty((String)this.getGroupCode()) ? "" : this.getGroupCode();
    }
}

