package com.xforceplus.reconciliationbill.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author wangzheng
 * @date 2020-06-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReconBillItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "reconciliation-manage")
public interface ReconBillItemFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/reconBillItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param reconBillItem ${table.comment}
   * @return R
   */
  @PostMapping("/reconBillItem/add")
  public R save(@RequestBody ReconBillItem reconBillItem);

  /**
   * 修改${table.comment}
   * @param reconBillItem ${table.comment}
   * @return R
   */
  @PostMapping("/reconBillItem/update")
  public R updateById(@RequestBody ReconBillItem reconBillItem);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/reconBillItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}