package com.xforceplus.reconciliationbill.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author wangzheng
 * @date 2020-06-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReconSelfConf;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "reconciliation-manage")
public interface ReconSelfConfFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/reconSelfConf/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param reconSelfConf ${table.comment}
   * @return R
   */
  @PostMapping("/reconSelfConf/add")
  public R save(@RequestBody ReconSelfConf reconSelfConf);

  /**
   * 修改${table.comment}
   * @param reconSelfConf ${table.comment}
   * @return R
   */
  @PostMapping("/reconSelfConf/update")
  public R updateById(@RequestBody ReconSelfConf reconSelfConf);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/reconSelfConf/del/{id}" )
  public R removeById(@PathVariable Long id);

}