package com.xforceplus.reconciliationbill.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author wangzheng
 * @date 2020-06-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReconSelfItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "reconciliation-manage")
public interface ReconSelfItemFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/reconSelfItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param reconSelfItem ${table.comment}
   * @return R
   */
  @PostMapping("/reconSelfItem/add")
  public R save(@RequestBody ReconSelfItem reconSelfItem);

  /**
   * 修改${table.comment}
   * @param reconSelfItem ${table.comment}
   * @return R
   */
  @PostMapping("/reconSelfItem/update")
  public R updateById(@RequestBody ReconSelfItem reconSelfItem);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/reconSelfItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}