package com.xforceplus.reconciliationbill.dict;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author wangzheng
 * @since ${date}
 */
public enum InvoiceType {

    C("c", "增值税普通发票"),
    S("s", "增值税专用发票"),
    V("v", "机动车销售发票"),
    T("t", "通用机打发票"),
    CE("ce", "增值税电子普通发票"),
    SE("se", "增值税电子专用发票"),
    JU("ju", "增值税普通发票(卷票)"),
    CT("ct", "增值税电子普通发票(通行费)"),
    Y("y", "运输业增值税专用发票");

    String code;

    String desc;

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return desc + "(" + code + ")";
    }

}
