package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.CustomerProject;
import com.xforceplus.reconciliationbill.service.ICustomerProjectService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-06-24
 */
@RestController
public class CustomerProjectController {

  @Autowired
  private ICustomerProjectService customerProjectServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customerProject ${table.comment}
   * @return
   */
  @GetMapping("/customerprojects" )
  public XfR getCustomerProjects(XfPage page, CustomerProject customerProject) {
    return XfR.ok(customerProjectServiceImpl.page(page, Wrappers.query(customerProject)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/customerprojects/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customerProjectServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param customerProject ${table.comment}
   * @return XfR
   */
  @PostMapping("/customerprojects")
  public XfR save(@RequestBody CustomerProject customerProject) {
     return XfR.ok(customerProjectServiceImpl.save(customerProject));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param customerProject ${table.comment}
   * @return XfR
   */
  @PutMapping("/customerprojects/{id}")
  public XfR putUpdate(@RequestBody CustomerProject customerProject,@PathVariable Long id) {
      customerProject.setId(id);
      return XfR.ok(customerProjectServiceImpl.updateById(customerProject));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param customerProject ${table.comment}
   * @return XfR
   */
  @PatchMapping("/customerprojects/{id}")
  public XfR patchUpdate(@RequestBody CustomerProject customerProject,@PathVariable Long id) {
      CustomerProject upcustomerProject = customerProjectServiceImpl.getById(id);
      if(upcustomerProject != null){
        upcustomerProject = ObjectCopyUtils.copyProperties(customerProject,upcustomerProject,true);
      }
      return XfR.ok(customerProjectServiceImpl.updateById(upcustomerProject));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customerprojects/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customerProjectServiceImpl.removeById(id));
  }

  @PostMapping("/customerprojects/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "customerproject");
      params.put("request", condition);

     return XfR.ok(customerProjectServiceImpl.querys(params));
  }

}
